#ifndef __rsdialog_h
#define __rsdialog_h

#include <wx/wx.h>

#define RS_TODIALOG 0
#define RS_TODATA 1

#define RS_CANCEL -1
#define RS_OK 1

class RSDialog : public wxDialog
{
public:
	RSDialog();

	int RunModal(const char *rs, wxWindow *parent);
	
	wxTextCtrl    *TXT(int id);
	wxCheckBox    *CHK(int id);
	wxButton      *BTN(int id);
	wxStaticText  *LBL(int id);
	wxListBox     *LB(int id);
	wxRadioButton *RB(int id);
	wxSlider      *SL(int id);
	wxScrollBar   *SB(int id);
	wxChoice      *CH(int id);

	void SetCancelOnEscape(bool b = true);

	void Exch_Text(int Dir, int ControlID, wxString &Field);
	void Exch_TextAsInt(int Dir, int ControlID, int &Value);
	void Exch_TextAsDouble(int Dir, int ControlID, double &Value, int Precision);
	void Exch_Check(int Dir, int ControlID, bool &Value);
	void Exch_Radio(int Dir, int ControlID, int &Result);
	void Exch_Slider(int Dir, int ControlID, int &Value);
	void Exch_ScrollBar(int Dir, int ControlID, int &Value);
	void Exch_Choice(int Dir, int ControlID, int &Value);
	void Exch_ChoiceAsText(int Dir, int ControlID, wxString &Value);

	virtual void OnDlgShow();

private:
	virtual void OnCharHook(wxKeyEvent &evt);

	bool bCancelOnEscape;
	DECLARE_EVENT_TABLE()
};


#endif
