#ifndef XCSWX_H
#define XCSWX_H

#include <wx/grid.h>
#include <wx/log.h>

#include "xcspropedit.h"
#include "dlgselect.h"

class DlgSelector;

class XcsApp : public wxApp
{
public:
	XcsApp();
	bool OnInit();
	int OnExit();
	
};

DECLARE_APP(XcsApp)

wxResourceTable *GetResourceTable();


#define MAX_RECENT 9

class XcsGUIView;

class XcsFrame : public wxFrame
{
public:
	XcsFrame();
	virtual ~XcsFrame();

	void NewProject();
	void LoadProject(const wxString &fn);
	void OpenProject();
	void SaveProject();
	void SaveProjectAs();
	bool CloseProject();
	void WriteWxr();
	void WriteRs();
	void ShowHelp();
	void ExitXcsite();
	void UpdateControlStatus();
	wxMenu *GetPopupMenu();

	DlgSelector *GetDlgSelector();

private:
	void OnAddControl(wxCommandEvent &evt);
	void OnDocumentCommand(wxCommandEvent &evt);
	void OnEditCommand(wxCommandEvent &evt);
	void OnRecent(wxCommandEvent &evt);
	void OnAbout(wxCommandEvent &evt);
	void OnHelp(wxCommandEvent &evt);

	void OnTestRS(wxCommandEvent &evt);

	void OnCloseFrame(wxCloseEvent &evt);
	void OnExit(wxCommandEvent &evt);
	
	void UpdateTitlebar();
	void AddRecent(const wxString &fn);
	void RemoveRecent(const wxString &fn);
	void UpdateRecentMenu();

	wxMenu *mFileMenu;
	wxMenu *mEditMenu;
	wxMenu *mPopupMenu;
	wxMenu *mRecentMenu;

	wxToolBar *mToolBar;

	XcsPropEdit *mPropEdit;
	XcsGUIView *mGUIView;
	XcsHelp *mHelpView;
	DlgSelector *mDlgSelect;
	
	int mRecentCount;
	wxString mRecentFiles[MAX_RECENT];

	
	/* project information */
	wxString mFilename;
	
	DECLARE_EVENT_TABLE()
};

#endif
