
#include <stdio.h>
#include <stdlib.h>

#include <wx/wx.h>
#include <wx/accel.h>
#include <wx/image.h>
#include <wx/fs_zip.h>
#include <wx/html/htmlwin.h>
#include <wx/config.h>
#include <wx/toolbar.h>

#include "dlgselect.h"
#include "guibuiltin.h"
#include "controls.h"
#include "xcsguiview.h"
#include "xcshelp.h"
#include "xcspropedit.h"
#include "xcswx.h"
#include "writecode.h"
#include "rsdialog.h"
#include "../rs_test/RS_NewDialog.r"
#include "../rs_test/RS_NewDialog.h"

//#include "dialogs/DlgEditText.wxr"

#include "pixmaps/stock_new.xpm"
#include "pixmaps/stock_open.xpm"
#include "pixmaps/stock_save.xpm"
#include "pixmaps/stock_save_as.xpm"
#include "pixmaps/stock_help.xpm"
#include "pixmaps/xcs_icon.xpm"

/* application global variables */

static XcsFrame *app_frame = NULL;
static wxArrayString app_args;
static wxConfig *app_config = NULL;

/* XcsFrame implementation */

IMPLEMENT_APP(XcsApp)


XcsApp::XcsApp()
{
	/* nothing to do */
}

bool XcsApp::OnInit()
{
	for (int i=0;i<argc;i++)
		app_args.Add(argv[i]);

#ifdef MESSAGES
	printf("Xcsite : Starting up...\n");
	printf("Command line args: %d\n", app_args.Count());
	for (int i=0;i<app_args.Count();i++)
		printf("argv[%d]: '%s'\n", i, app_args[i].c_str());
	
#endif

	/* initialize the configuration system */
	app_config = new wxConfig("Xcsite2", "jland.org");

	/* needed for the html help viewer */
    wxImage::AddHandler(new wxPNGHandler);
    wxImage::AddHandler(new wxJPEGHandler);
    wxFileSystem::AddHandler(new wxZipFSHandler);

	app_frame = new XcsFrame;
	app_frame->Centre(wxBOTH);
	app_frame->Show(true);

	SetTopWindow(app_frame);

	if ((int)app_args.Count() > 1)
		app_frame->LoadProject(app_args[1]);
	
	return true;
}

int XcsApp::OnExit()
{	
	// delete the app config
	// (it automatically writes the configuration)
	delete app_config;
	
#ifdef MESSAGES
	printf("Xcsite: Shutdown complete.\n");
#endif
	
	return 1;
}

enum{	XCS_NEW, XCS_OPEN, XCS_SAVE, XCS_SAVEAS, XCS_CLOSEFILE, 
		XCS_WRITE_WXR, XCS_WRITE_RS,
		XCS_RECENT_FILES, XCS_EXIT,
		
		XCS_DELETE, XCS_TEST_RS,
		XCS_ALIGN_LEFT, XCS_ALIGN_RIGHT, XCS_ALIGN_TOP, XCS_ALIGN_BOTTOM,

		XCS_ABOUT, XCS_HELP,
		XCS_DLGCOMBO,

		// this must be the last ID so in the enum
		// that any number of recent files can be used.
		XCS_RECENT

};

BEGIN_EVENT_TABLE(XcsFrame, wxFrame)
	EVT_MENU( XCS_NEW,                    XcsFrame::OnDocumentCommand )
	EVT_MENU( XCS_OPEN,                   XcsFrame::OnDocumentCommand )
	EVT_MENU( XCS_SAVE,                   XcsFrame::OnDocumentCommand )
	EVT_MENU( XCS_SAVEAS,                 XcsFrame::OnDocumentCommand )
	EVT_MENU( XCS_CLOSEFILE,              XcsFrame::OnDocumentCommand )
	EVT_MENU( XCS_WRITE_WXR,              XcsFrame::OnDocumentCommand )
	EVT_MENU( XCS_WRITE_RS,               XcsFrame::OnDocumentCommand )
	EVT_MENU( XCS_EXIT,                   XcsFrame::OnExit )

	EVT_MENU( XCS_DELETE,                 XcsFrame::OnEditCommand )
	EVT_MENU( XCS_ALIGN_LEFT,             XcsFrame::OnEditCommand )
	EVT_MENU( XCS_ALIGN_RIGHT,            XcsFrame::OnEditCommand )
	EVT_MENU( XCS_ALIGN_TOP,              XcsFrame::OnEditCommand )
	EVT_MENU( XCS_ALIGN_BOTTOM,           XcsFrame::OnEditCommand )
	
	EVT_MENU( XCS_TEST_RS,                XcsFrame::OnTestRS )
	

	EVT_MENU( XCS_ABOUT, XcsFrame::OnAbout )
	EVT_MENU( XCS_HELP, XcsFrame::OnHelp )
	
	EVT_CLOSE( XcsFrame::OnCloseFrame )

	// For recent file menu
	EVT_MENU( XCS_RECENT+0, XcsFrame::OnRecent)
	EVT_MENU( XCS_RECENT+1, XcsFrame::OnRecent)
	EVT_MENU( XCS_RECENT+2, XcsFrame::OnRecent)
	EVT_MENU( XCS_RECENT+3, XcsFrame::OnRecent)
	EVT_MENU( XCS_RECENT+4, XcsFrame::OnRecent)
	EVT_MENU( XCS_RECENT+5, XcsFrame::OnRecent)
	EVT_MENU( XCS_RECENT+6, XcsFrame::OnRecent)
	EVT_MENU( XCS_RECENT+7, XcsFrame::OnRecent)
	EVT_MENU( XCS_RECENT+8, XcsFrame::OnRecent)
	EVT_MENU( XCS_RECENT+9, XcsFrame::OnRecent) // this must go all the way to MAX_RECENT-1

	// For control creation
	EVT_MENU( XCS_ADD_CONTROL_ID, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+1, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+2, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+3, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+4, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+5, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+6, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+7, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+8, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+9, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+10, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+11, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+12, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+13, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+14, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+15, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+16, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+17, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+18, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+19, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+20, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+21, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+22, XcsFrame::OnAddControl)
	EVT_MENU( XCS_ADD_CONTROL_ID+23, XcsFrame::OnAddControl)


END_EVENT_TABLE()

XcsFrame::XcsFrame()
	: wxFrame(NULL, -1, "Xcsite", wxDefaultPosition, wxSize(700, 600))
{
	int i;

	mFilename = "";
	mRecentCount = 0;
	CreateStatusBar(4);


	wxString helpfile = wxPathOnly(app_args[0]) + "/xcshelp.zip#zip:index.html";
	mHelpView = new XcsHelp(helpfile);

#ifdef __WXMSW__
	SetIcon( wxIcon("aficon") );
#else
	SetIcon( wxIcon( xcs_icon_xpm ) );
#endif

	mRecentMenu = new wxMenu;

	mFileMenu = new wxMenu;
	mFileMenu->Append(XCS_NEW, "New Project\tCtrl+N", "Create new project");
	mFileMenu->AppendSeparator();
	mFileMenu->Append(XCS_OPEN, "Open Existing\tCtrl+O", "Open a project");
	mFileMenu->Append(XCS_SAVE, "Save\tCtrl+S", "Save project");
	mFileMenu->Append(XCS_SAVEAS, "Save As...", "Save as a different file");
	mFileMenu->AppendSeparator();
	mFileMenu->Append(XCS_CLOSEFILE, "Close Project", "Close the project");
	mFileMenu->AppendSeparator();
	mFileMenu->Append(XCS_WRITE_WXR, "Generate WXR Resources\tCtrl-G", "Generate the WXR resource and header files");
	mFileMenu->Append(XCS_WRITE_RS, "Generate RS Resources\tCtrl-R", "Generate the RS resource and header files");
	mFileMenu->AppendSeparator();
	mFileMenu->Append(XCS_RECENT_FILES, "Recent", mRecentMenu, "Load a recently opened project");
	mFileMenu->AppendSeparator();
	mFileMenu->Append(XCS_EXIT, "Exit\tCtrl+W", "Exit Xcsite");


	mEditMenu = new wxMenu;
	mEditMenu->Append(XCS_DELETE, "Delete\tCtrl-D", "Delete the current control");
	mEditMenu->AppendSeparator();
	mEditMenu->Append(XCS_ALIGN_LEFT, "Align Left Edges");
	mEditMenu->Append(XCS_ALIGN_RIGHT, "Align Right Edges");
	mEditMenu->Append(XCS_ALIGN_TOP, "Align Top Edges");
	mEditMenu->Append(XCS_ALIGN_BOTTOM, "Align Bottom Edges");
	//mEditMenu->AppendSeparator();
	//mEditMenu->Append(XCS_TEST_RS, "Test RS Dialog");

	wxMenu *help_menu = new wxMenu;
	help_menu->Append(XCS_ABOUT, "About...");
	help_menu->AppendSeparator();
	help_menu->Append(XCS_HELP, "Help\tF1");
	
	wxMenuBar *menubar = new wxMenuBar;
	menubar->Append(mFileMenu, "File");
	menubar->Append(mEditMenu, "Edit");
	menubar->Append(help_menu, "Help");

	
	SetMenuBar( menubar );
	
	mPopupMenu = new wxMenu();
/*	mPopupMenu->AppendCheckItem(XCS_TOGGLE_MOVECHIP, "Toggle Move Chip", "Move the chip around");
	mPopupMenu->Append(XCS_ROTATECHIP, "Rotate Chip", "Rotate the chip");*/
	mPopupMenu->AppendSeparator();

	
	mToolBar  = CreateToolBar();

	int count = 0;
	ControlInfo *controls = XcsGetControls(count);
	for (i=0;i<count;i++)
	{
		mToolBar->AddTool( controls[i].wxid, wxBitmap( (const char **)controls[i].pixmap21x21), wxString("Create a new ") + wxString( controls[i].name ) );
	}

	mToolBar->SetToolBitmapSize( wxSize(21, 21) );
	mToolBar->Realize();

	mGUIView = new XcsGUIView(this);

	mPropEdit = new XcsPropEdit(this, mGUIView);
	mGUIView->SetPropEditor(mPropEdit);

	mDlgSelect = new DlgSelector( this, mGUIView );

	wxFlexGridSizer *sizer = new wxFlexGridSizer(2, 3, 2, 2);
	sizer->AddGrowableCol(1);
	sizer->AddGrowableRow(0);

	
	sizer->Add(mDlgSelect, 1, wxEXPAND);
	sizer->Add(mGUIView, 1, wxEXPAND);
	sizer->Add(mPropEdit, 1, wxEXPAND);
	
	SetSizer( sizer );
	sizer->SetSizeHints( this );

	SetSize(770, 630);
	
	long ct = 0;
	if (app_config->Read("RecentCount", &ct))
		mRecentCount = (int)ct;

	if (mRecentCount > MAX_RECENT)
		mRecentCount = MAX_RECENT;

	for (i=0;i<mRecentCount;i++)
	{
		wxString key;
		key.Printf("RecentFile_%d", i);
		wxString fn;
		if (app_config->Read(key, &fn))
			mRecentFiles[i] = fn;
	}

	UpdateTitlebar();
	UpdateRecentMenu();
	UpdateControlStatus();

}

XcsFrame::~XcsFrame()
{
	// save the recent file settings

	long ct = (long)mRecentCount;
	app_config->Write("RecentCount", ct);
	for (int i=0;i<mRecentCount;i++)
	{
		wxString key;
		key.Printf("RecentFile_%d", i);
		app_config->Write(key, mRecentFiles[i]);
	}

	mHelpView->Destroy();

	if (mPopupMenu != NULL)
	{
		delete mPopupMenu;
	}

#ifdef MESSSAGES
	printf("~XcsFrame: destructing the main window...\n");
#endif
}

DlgSelector *XcsFrame::GetDlgSelector()
{
	return mDlgSelect;
}

void XcsFrame::OnEditCommand(wxCommandEvent &evt)
{
	switch(evt.GetId())
	{
	case XCS_DELETE:
	  {
		Dialog *dlg = mGUIView->GetActiveDialog();
		if (dlg != NULL)
		{
			int i, ct = mGUIView->GetSelectedCount();
			if (ct == 1 && mGUIView->GetSelected(0) == dlg)
			{
				int ret = wxMessageBox("Really delete the active dialog?", "Query", wxYES_NO|wxICON_WARNING);
				if (ret == wxNO)
					return;

				mGUIView->ClearSelections();
				mGUIView->SetActiveDialog(NULL);
				dlg->DeleteChildren();
				mGUIView->RemoveDialog( dlg );
				mDlgSelect->UpdateList();
			}
			else
			{
				for (i=0;i<ct;i++)
				{
					if (mGUIView->GetSelected(i) != dlg)
					{
						mGUIView->GetActiveDialog()->RemoveChild( mGUIView->GetSelected(i) );
						delete mGUIView->GetSelected(i);
					}
				}
				mGUIView->ClearSelections();
			}
		}
		break;
	  }
	case XCS_ALIGN_LEFT:
		mGUIView->AlignLeftEdges();
		break;
	case XCS_ALIGN_RIGHT:
		mGUIView->AlignRightEdges();
		break;
	case XCS_ALIGN_TOP:
		mGUIView->AlignTopEdges();
		break;
	case XCS_ALIGN_BOTTOM:
		mGUIView->AlignBottomEdges();
		break;

	default:
		break;
	}
}

void XcsFrame::UpdateRecentMenu()
{
	int i;
	for (i=0;i<MAX_RECENT;i++)
	{
		if (mRecentMenu->FindItem(XCS_RECENT+i) != NULL)
			mRecentMenu->Destroy(XCS_RECENT+i);
	}

	for (i=0;i<mRecentCount;i++)
	{
		wxString name;
		name.Printf("%d  %s", i+1, mRecentFiles[i].c_str());
		mRecentMenu->Append(XCS_RECENT+i, name);
	}
}

void XcsFrame::OnRecent(wxCommandEvent &evt)
{
	int id = evt.GetId() - XCS_RECENT;
	if (id < 0 || id >= MAX_RECENT)
		return;

	if (!CloseProject())
		return;

	wxString fn = mRecentFiles[id];
	if (fn != "")
	{
		//wxMessageBox("loading recent file " + fn);
		LoadProject(fn);
	}
}

void XcsFrame::AddRecent(const wxString &fn)
{
	int i;
	int index = -1;
	// find the file in the recent list
	for (i=0;i<mRecentCount;i++)
	{
		if (fn == mRecentFiles[i])
		{
			index = i;
			break;
		}
	}

	if (index >= 0)
	{
		// bring this file to the front of the
		// recent file list

		for (i=index;i>0;i--)
			mRecentFiles[i] = mRecentFiles[i-1];
	}
	else // not found in recent list
	{
		// add this to the front of the recent list
		// and increment the recent count if its 
		// less than MAX_RECENT

		for (i=MAX_RECENT-1;i>0;i--)
			mRecentFiles[i] = mRecentFiles[i-1];

		if (mRecentCount < MAX_RECENT)
			mRecentCount++;
	}
	
	mRecentFiles[0] = fn;
	UpdateRecentMenu();
}

void XcsFrame::RemoveRecent(const wxString &fn)
{
	int i;
	int index = -1;
	// find the file in the recent list
	for (i=0;i<mRecentCount;i++)
	{
		if (fn == mRecentFiles[i])
		{
			index = i;
			break;
		}
	}

	if (index >= 0)
	{
		for (i=index;i<MAX_RECENT-1;i++)
			mRecentFiles[i] = mRecentFiles[i+1];

		mRecentCount--;
		UpdateRecentMenu();
	}
}

wxMenu *XcsFrame::GetPopupMenu()
{
	return mPopupMenu;
}

void XcsFrame::ShowHelp()
{
	mHelpView->Show();
}

void XcsFrame::OnAddControl(wxCommandEvent &evt)
{
	int wxid = evt.GetId();
	ControlInfo *ctrlinfo = XcsFindControlInfo(wxid);
	if (!ctrlinfo)
	{
		wxMessageBox("Bad Control");
	}
	else
	{
		mGUIView->CreateNewControl(ctrlinfo);
	}
}

void XcsFrame::OnDocumentCommand(wxCommandEvent &evt)
{
	switch(evt.GetId())
	{
	case XCS_NEW:
		NewProject();
		break;
	case XCS_OPEN:
		OpenProject();
		break;
	case XCS_SAVE:
		SaveProject();
		break;
	case XCS_SAVEAS:
		SaveProjectAs();
		break;
	case XCS_CLOSEFILE:
		CloseProject();
		break;
	case XCS_WRITE_WXR:
		WriteWxr();
		break;
	case XCS_WRITE_RS:
		WriteRs();
		break;
	default:
		break;
	}
}

void XcsFrame::OnTestRS(wxCommandEvent &evt)
{
	RSDialog dlg;
	dlg.RunModal(RS_NewDialog, this);
}

void XcsFrame::NewProject()
{
	if (CloseProject())
	{
		mGUIView->ClearAll();
		mFilename = "";
		UpdateControlStatus();
		UpdateTitlebar();
	}
}

void XcsFrame::OpenProject()
{
	if (!CloseProject())
		return;

	wxFileDialog fdlg(this, "Open Project", wxGetCwd(), "", "(XCS Database File)|*.xcd|(DDB Files)|*.ddb|(All Files)|*.*", wxOPEN|wxHIDE_READONLY);

	if (fdlg.ShowModal() == wxID_OK)
	{
		LoadProject(fdlg.GetPath());
		wxSetWorkingDirectory( wxPathOnly( fdlg.GetPath() ) );
	}
	
}

void XcsFrame::SaveProject()
{
	if (mFilename == "")
	{
		SaveProjectAs();
		return;
	}
	else
	{
		wxFileName fndata(mFilename);
		if (fndata.GetExt() == "ddb")
		{
			wxMessageBox("XCS does not support writing of DED database (*.ddb) files.  Save the project as an *.xcd file instead.", "Save Error", wxOK | wxICON_ERROR);
			return;
		}

		FILE *fp = fopen(mFilename.c_str(), "w");
		if (!fp)
		{
			wxMessageBox("Could not open file for writing.", "Error", wxOK|wxICON_ERROR);
			return;
		}
		if (!mGUIView->WriteDatabase(fp))
			wxMessageBox("An error occured while writing the project database file.", "Error", wxOK|wxICON_ERROR);

		fclose(fp);
		UpdateControlStatus();
		UpdateTitlebar();
	}
}

void XcsFrame::SaveProjectAs()
{
	wxFileDialog fdlg(this, "Save As '" + mFilename + "' As", wxGetCwd(), 
		wxFileNameFromPath(mFilename), "(XCS Database File)|*.xcd|(All Files)|*.*", wxSAVE|wxOVERWRITE_PROMPT|wxHIDE_READONLY);

	if (fdlg.ShowModal() == wxID_OK)
	{
		mFilename = fdlg.GetPath();
		if (mFilename != "")
			SaveProject();
	}
}

bool XcsFrame::CloseProject()
{
	if (mGUIView->IsDirty())
	{
		int ret = wxMessageBox("The project has been modified.  Save it before closing?", "Query", wxYES_NO | wxCANCEL | wxICON_WARNING);
		if (ret == wxCANCEL)
			return false;
		else if (ret == wxYES)
		{
			SaveProject();
			if (mGUIView->IsDirty())
				return false;
		}
	}
	mGUIView->ClearAll();
	UpdateTitlebar();
	return true;
}

void XcsFrame::LoadProject(const wxString &fn)
{
	if (CloseProject())
	{
		mGUIView->ClearAll();
		FILE *fp = fopen( fn.c_str(), "r");
		if (fp)
		{
			wxFileName fndata(fn);
			if (mGUIView->ReadDatabase( fp, fndata.GetExt() == "ddb"))
				mFilename = fn;

			fclose( fp );
			AddRecent(fn);
			UpdateControlStatus();
			UpdateTitlebar();
		}
	}
}

void XcsFrame::OnCloseFrame( wxCloseEvent &evt )
{
	if (evt.CanVeto() && !CloseProject())
	{
		evt.Veto();
		return;
	}
	
	Destroy();
}


void XcsFrame::ExitXcsite()
{
	Close( false );
}


void XcsFrame::OnExit(wxCommandEvent &evt)
{
	ExitXcsite();
}

void XcsFrame::UpdateTitlebar()
{
	wxString title;
	title.Printf("%s - XCS Database Editor",mFilename.length() > 0 ? wxFileNameFromPath(mFilename).c_str() : "No Dialog Database");
	SetTitle( title );
}


void XcsFrame::OnAbout(wxCommandEvent &evt)
{
	wxString msg;
	msg.Printf("XCS - Version 1.3\n"
		"Xcsite-based Dialog Editor\n\n"
		"Copyright (c) 2004-2005 Aron Dobos");
	wxMessageBox(msg,"About XCS", wxOK | wxICON_INFORMATION);
	
}

void XcsFrame::OnHelp(wxCommandEvent &evt)
{
	mHelpView->Show();
}

void XcsFrame::UpdateControlStatus()
{
	mFileMenu->Enable(XCS_RECENT_FILES, mRecentCount > 0);
	mFileMenu->Enable(XCS_SAVE, mGUIView->IsDirty());
}

void XcsFrame::WriteWxr()
{

	wxDirDialog dlg(this, "Destination for WXR Output", wxPathOnly(mFilename), wxDD_NEW_DIR_BUTTON);
	if (dlg.ShowModal() == wxID_OK && dlg.GetPath() != wxEmptyString)
	{
		Array<Dialog*> list;
		int ct = mGUIView->GetDialogCount();
		for (int i=0;i<ct;i++)
			list.append( mGUIView->GetDialog(i) );

		if (!write_wxr(dlg.GetPath(), list))
			wxMessageBox("An error occured when writing the WXR files.", "Error", wxOK|wxICON_ERROR);	
		else
			wxMessageBox(wxString::Format("WXR resource files successfully generated in %s.", dlg.GetPath().c_str()), "XCS", wxOK|wxICON_INFORMATION);
	}
	
}

void XcsFrame::WriteRs()
{

	wxDirDialog dlg(this, "Destination for RS Resource Output", wxPathOnly(mFilename), wxDD_NEW_DIR_BUTTON);
	if (dlg.ShowModal() == wxID_OK && dlg.GetPath() != wxEmptyString)
	{
		Array<Dialog*> list;
		int ct = mGUIView->GetDialogCount();
		for (int i=0;i<ct;i++)
			list.append( mGUIView->GetDialog(i) );

		if (!write_rs(dlg.GetPath(), list))
			wxMessageBox("An error occured when writing the RS files.", "Error", wxOK|wxICON_ERROR);	
		else
			wxMessageBox(wxString::Format("RS resource files successfully generated in %s.", dlg.GetPath().c_str()), "XCS", wxOK|wxICON_INFORMATION);
	}
	
}