#ifndef __xcspropedit_h
#define __xcspropedit_h

#define MAX_EDIT_PROPS 20

class EditorCtrl;

#include "controls.h"


struct pinfo
{
	XcsPropEdit *pedit;
	Property *prop;
	wxString name;
	int type;
	wxRect labelarea;
	wxRect ctrlarea;
	EditorCtrl *ctrl;
	bool updating;
};

class XcsPropEdit : public wxWindow
{
public:
	XcsPropEdit(wxWindow *parent, XcsGUIView *view);
	virtual ~XcsPropEdit();

	void SetObject(Object* obj);
	void UpdateView();
	void PropertyToView(const pinfo &inf);
	XcsGUIView *GetGUIView();

private:
	void RedrawAll();
	void DoLayout();
	void Draw(wxDC &dc);

	void OnLeftButtonDown(wxMouseEvent &evt);
	void OnLeftDblClick(wxMouseEvent &evt);
	void OnLeftButtonUp(wxMouseEvent &evt);
	void OnRightButtonDown(wxMouseEvent &evt);
	void OnKeyEvent(wxKeyEvent &evt);
	void OnMouseMove(wxMouseEvent &evt);
	void OnSize(wxSizeEvent &evt);
	void OnPaint(wxPaintEvent &evt);

	Object *mCurrentObj;
	XcsGUIView *mGUIView;

	wxBitmap *mBufBitmap;

	
	pinfo mPInfo[MAX_EDIT_PROPS];
	int nProps;

DECLARE_EVENT_TABLE();
};

#endif
