
#include <wx/wx.h>
#include <wx/html/htmlwin.h>

#include "xcshelp.h"
#include "pixmaps/stock_close.xpm"
#include "pixmaps/stock_left_arrow.xpm"
#include "pixmaps/stock_right_arrow.xpm"
#include "pixmaps/xcs_icon.xpm"

enum { XCSHELP_CLOSE, XCSHELP_BACK, XCSHELP_FORWARD };

BEGIN_EVENT_TABLE( XcsHelp, wxFrame )
	EVT_TOOL( XCSHELP_BACK, XcsHelp::OnTool )
	EVT_TOOL( XCSHELP_FORWARD, XcsHelp::OnTool )
	EVT_TOOL( XCSHELP_CLOSE, XcsHelp::OnTool )
	
	EVT_CLOSE( XcsHelp::OnCloseFrame )
END_EVENT_TABLE();

XcsHelp::XcsHelp(const wxString &zipfile)
	: wxFrame(NULL, -1, "XCS Help", wxDefaultPosition, wxSize(600, 600))
{

#ifdef __WXMSW__
	SetIcon( wxIcon("aficon") );
#else
	SetIcon( wxIcon( xcs_icon_xpm ) );
#endif

	mZipFilePath = zipfile;

    CreateStatusBar(1);
		
	mToolBar = CreateToolBar();
	mToolBar->AddTool( XCSHELP_CLOSE, wxBitmap( stock_close_xpm ), "Close Help" );
	mToolBar->AddTool( XCSHELP_BACK, wxBitmap( stock_left_arrow_xpm ), "Go Back" );
	mToolBar->AddTool( XCSHELP_FORWARD, wxBitmap( stock_right_arrow_xpm ), "Go Forward" );
    mToolBar->SetToolBitmapSize(wxSize(24, 24));	
	mToolBar->Realize();

    mHtml = new wxHtmlWindow( this );
    mHtml->SetRelatedFrame(this, "XCS Help : %s");
    mHtml->SetRelatedStatusBar(0);
    mHtml->LoadPage(mZipFilePath);
}

XcsHelp::~XcsHelp()
{
	/* nothing to do yet */
}

void XcsHelp::OnTool(wxCommandEvent &evt)
{
	switch(evt.GetId())
	{
	case XCSHELP_CLOSE:
		Hide();
		break;
	case XCSHELP_BACK:
		mHtml->HistoryBack();
		break;
	case XCSHELP_FORWARD:
		mHtml->HistoryForward();
	default:
		break;
	}
}

void XcsHelp::OnCloseFrame(wxCloseEvent &evt)
{
	Hide();
	evt.Veto();
}
