#ifndef XCSVIEW_H
#define XCSVIEW_H

#include <wx/wx.h>
#include "controls.h"

class XcsFrame;
class XcsPropEdit;

enum ActionType { ACTION_CUT, ACTION_COPY, ACTION_PASTE, 
	ACTION_DELETE, ACTION_MOVE, ACTION_RESIZE };

class ActionInfo
{
public:
	ActionInfo(ActionType type);
	~ActionInfo();

	ActionType type;
};


class XcsGUIView : public wxWindow
{
public:
	XcsGUIView(XcsFrame *frm);
	virtual ~XcsGUIView();

	void SetPropEditor(XcsPropEdit *pedit);

	void CreateNewControl(ControlInfo *ctrlinfo);

	void AddDialog(Dialog *frm);
	void RemoveDialog(Dialog *frm);
	Dialog *FindDialog(const wxString &name);
	Dialog *FindDialogByTitle(const wxString &title);
	void SetActiveDialog(Dialog *frm);
	Dialog *GetActiveDialog();
	void DeleteDialogs();
	int GetDialogCount();
	Dialog *GetDialog(int i);

	bool AreObjectsSelected();
	int GetSelectedCount();
	Object *GetSelected(int i);
	void ClearSelections();

	void AlignTopEdges();
	void AlignLeftEdges();
	void AlignRightEdges();
	void AlignBottomEdges();

	void SetDirty(bool d = true);
	bool IsDirty();

	bool CanUndo();
	bool CanRedo();
	wxString GetUndoString();
	wxString GetRedoString();
	void FreeUndoStack();
	void FreeRedoStack();
	void Undo();
	void Redo();

	void RedrawAll();
	void Draw(wxDC &dc);

	void OnLeftButtonDown(wxMouseEvent &evt);
	void OnLeftButtonUp(wxMouseEvent &evt);
	void OnRightButtonDown(wxMouseEvent &evt);
	void OnKeyEvent(wxKeyEvent &evt);
	void OnMouseMove(wxMouseEvent &evt);
	void OnSize(wxSizeEvent &evt);
	void OnPaint(wxPaintEvent &evt);

	void ClearAll();

	bool WriteDatabase(FILE *fp);
	bool ReadDatabase(FILE *fp, bool dedcompat = false);

	XcsFrame *GetXcsFrame();

	void ShowLoadLog();
private:
	void WriteObject(FILE *fp, Object *obj, bool isdialog);
	bool ReadObject(FILE *fp, Dialog *parent, bool isdialog);

	Dialog *MakeNewDialog(const wxString &name);
	void DrawMoveResizeOutlines();
	int IsOverResizeBox(int x, int y, Object *obj);
	void SetResizeCursor(int pos = -1);
	wxRect GetFrameRect();
	void DrawFrameDecor(Painter &gfx);

	Dialog *mCurrentDialog;
	Array<Dialog*> mDialogs;
	Array<Object*> mSelectedItems;

	ActionInfo *mCurrentActionInfo;
	Array<ActionInfo*> mUndoStack;
	Array<ActionInfo*> mRedoStack;

	wxColour mFrameColour;
	wxColour mSelectColour;
	wxColour mForeground;
	wxColour mBackground;
	
	wxCursor mStandardCursor;
	wxCursor mMoveResizeCursor;
	wxCursor mNwSeCursor;
	wxCursor mNSCursor;
	wxCursor mWECursor;
	wxCursor mNeSwCursor;

	bool bDirty;
	bool bMoveMode;
	bool bMoveModeErase;
	int mOrigX, mOrigY, mDiffX, mDiffY, mDiffW, mDiffH;

	bool bDedCompat;
	bool bResizeMode;
	bool bResizeModeErase;
	int mResizeBox;

	wxBitmap *mBufBitmap;

	XcsFrame *mFrame;
	XcsPropEdit *mPropEdit;

	wxArrayString mLoadLog;

DECLARE_EVENT_TABLE()
};

#endif
