#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <wx/wx.h>

#include "array.h"
#include "writecode.h"

/*

static void codegen_dialog(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_button(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_checkbox(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_choice(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_staticbox(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_listbox(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_statictext(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_radiobutton(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_scrollbar(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_slider(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_textctrl(Object *inst, ObjClass *klass, FILE *fp);

*/

bool write_wxr(const wxString &dirname, const Array<Dialog*> &list)
{
	int id = 100;
	int i;
	
	// assign ids to the widgets	
	for (i=0;i<list.count();i++)
	{
		Dialog *dlg = list[i];
		dlg->SetId(id++);
		wxString fn = dirname + "/" + dlg->GetName() + ".h";
		
		FILE *fp = fopen(fn.c_str(), "w");
		if (!fp)
			return false;
		
		fprintf(fp, "#define ID_%s %d\n", dlg->GetName().c_str(), dlg->GetId());

			
		int count;
		Object **children = dlg->GetChildren(count);
		for (int i=0;i<count;i++)
		{
			Object *obj = children[i];
			obj->SetId(id++);
			fprintf(fp, "#define ID_%s %d\n", obj->GetName().c_str(), obj->GetId());
		}
		
		fclose(fp);
	}
	
	// generate the resource files
	for (i=0;i<list.count();i++)
	{
		Dialog *dlg = list[i];
		wxRect drct = dlg->GetGeom();
		wxString fn = dirname + "/" + dlg->GetName() + ".wxr";
	
		//printf("generating wxr file '%s'\n", fn.cStr());
		
		FILE *fp = fopen(fn.c_str(), "w");
		if (!fp)
			return false;
		
		// write the dialog properties	
		fprintf(fp, "static char *%s = \"dialog(name = '%s',\\\n", dlg->GetName().c_str(), dlg->GetName().c_str());
		fprintf(fp, "\"\"  style = 'wxRAISED_BORDER | wxCAPTION%s',\\\n", dlg->IsModal() ? " | wxDIALOG_MODAL" : "");
		fprintf(fp, "\"\"  title = '%s',\\\n", dlg->GetTitle().c_str());
		fprintf(fp, "\"\"  id = %d,\\\n", dlg->GetId());
		fprintf(fp, "\"\"  x = 10, y = 10, width = %d, height = %d,\\\n", drct.width, drct.height);
		fprintf(fp, "\"\"  background_colour = 'D6D6D6',\\\n");
		fprintf(fp, "\"\"  use_dialog_units = 0,\\\n");
		fprintf(fp, "\"\"  use_system_defaults = 1,\\\n");
		fprintf(fp, "\"\"  font = [12, 'wxSWISS', 'wxNORMAL', 'wxNORMAL', 0],\\\n");
				
#define WXFONTSPEC "\"\"      [12, 'wxSWISS', 'wxNORMAL', 'wxNORMAL', 0]],\\\n"

		// generate the code for widgets that are lowest on the 
		// stacking order, since the need to be added to the dialog first.
		// currently the only widget generated is a 'StaticBox'
		int count;
								
		Array<Object*> tabchildren; // to hold widgets with tab information
		Array<Object*> nontabchildren; // for all the other widgets
		Array<Object*> radiobuttons; // special list for radiobuttons since order matters for them
				
		int j;
		Object **children = dlg->GetChildren(count);
		for (j=0;j<count;j++)
		{
			children[j]->SetWxrDone(false);
				
			int curorder = -1;
			if ( (curorder = children[j]->GetTabOrder()) >= 0 )
			{
				/* insert the current tab child in sorted order into the tabchildren array */
				int index = 0;
				int k;
				for (k=0;k<tabchildren.count();k++)
				{
					if (tabchildren[k]->GetTabOrder() >= curorder)
						break;

					index++;
				}				
				tabchildren.insert(children[j], index);
			}
			else
			{
				/* this widget does not support tabordering */
				nontabchildren.append(children[j]);
			}
		}
		
		/* now append all the non tab children to the end of the tabchildren 
		to get one correct list of widgets to output the code for */
		
		for (j=0;j<nontabchildren.count();j++)
			tabchildren.append( nontabchildren[j] );

		
		/* now put all the radiobuttons into the list with the correct taborder */

		for (j=0;j<tabchildren.count();j++)
		{
			if (strcmp(tabchildren[j]->GetControlInfo()->name, "RadioButton") == 0)
				radiobuttons.append( tabchildren[j] );
		}
		
		/* now cycle through all the widgets in
		the correctly tab-order sorted list of widgets
		and generate the appropriate code. */
		
		/* write out all the lowered widgets first
		to make sure the they're the lowest on the 
		stacking order in the final dialog (only wxStaticBox here) */
		

		for (j=0;j<tabchildren.count();j++)
		{
			Object *obj = tabchildren[j];
			ControlInfo *kls = obj->GetControlInfo();
			wxRect rct = obj->GetGeom();

			rct.x -= drct.x;
			rct.y -= drct.y;
			
			// it's a lowered widget and it hasn't been written yet
			if (!obj->IsWxrDone())
			{
				if ( strcmp(kls->name, "StaticBox") == 0)
				{					
					fprintf(fp, "\"\"  control = [%d, wx%s, '%s', '0', '%s', %d, %d, %d, %d,\\\n",
							obj->GetId(), kls->name, obj->GetPropString("label").c_str(), obj->GetName().c_str(), 
							rct.x, rct.y, rct.width, rct.height);
					fprintf(fp, WXFONTSPEC);
					obj->SetWxrDone(true);
				}
				
			}
		}
		
		// generate code for all the other widgets,
		// but not the radio buttons, since
		// we need to generate those separately to get
		// the groups right
		


		for (j=0;j<tabchildren.count();j++)
		{
			Object *obj = tabchildren[j];
			ControlInfo *kls = obj->GetControlInfo();
			wxRect rct = obj->GetGeom();
			
			rct.x -= drct.x;
			rct.y -= drct.y;

			// make sure it's raised widget that hasn't been written yet
			if (!obj->IsWxrDone())
			{				
				if ( strcmp(kls->name, "Button") == 0 ||
						strcmp(kls->name, "StaticText") == 0 )
				{
					fprintf(fp, "\"\"  control = [%d, wx%s, '%s', '0', '%s', %d, %d, %d, %d, '',\\\n",
							obj->GetId(), kls->name, obj->GetPropString("label").c_str(), obj->GetName().c_str(),
							rct.x, rct.y, rct.width, rct.height);
					fprintf(fp, WXFONTSPEC);
					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "Choice") == 0 ||
						strcmp(kls->name, "ListBox") == 0 )
				{
					Property *p = obj->FindProp("data");
					wxString data = "[";
					if (p)
					{
						for (int k=0;k<(int)p->string_array.Count();k++)
						{
							data += "'" + p->string_array[k] + "'";
							if (k < (int)p->string_array.Count()-1)
								data += ", ";
						}
					}
					data += "]";
					
					wxString style = strcmp(kls->name, "ListBox")==0 ? "wxLB_SINGLE" : "0";
					
					fprintf(fp, "\"\"  control = [%d, wx%s, '', '%s', '%s', %d, %d, %d, %d, %s,\\\n",
							obj->GetId(), kls->name, style.c_str(), obj->GetName().c_str(),
							rct.x, rct.y, rct.width, rct.height, data.c_str());
					fprintf(fp, WXFONTSPEC);
					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "CheckBox") == 0)
				{
					wxString chk = "'0'";
				
					if (obj->GetPropBool("state"))
						chk = "'1'";
					
					fprintf(fp, "\"\"  control = [%d, wx%s, '%s', '0', '%s', %d, %d, %d, %d, %s,\\\n",
							obj->GetId(), kls->name, obj->GetPropString("label").c_str(), obj->GetName().c_str(),
							rct.x, rct.y, rct.width, rct.height, chk.c_str());
					fprintf(fp, WXFONTSPEC);
					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "ScrollBar") == 0)
				{
					int val=0, thumb=16, page=50, range=100;
					val = obj->GetPropInt("value");
					thumb = obj->GetPropInt("thumbsize");
					page = obj->GetPropInt("pagesize");
					range = obj->GetPropInt("range");
					
					wxString style = "'wxSB_HORIZONTAL'";
					if (obj->GetPropBool("vertical"))
						style = "'wxSB_VERTICAL'";
					
					fprintf(fp, "\"\"  control = [%d, wx%s, '', %s, '%s', %d, %d, %d, %d, %d, %d, %d, %d],\\\n",
						obj->GetId(), kls->name, style.c_str(), obj->GetName().c_str(),
							rct.x, rct.y, rct.width, rct.height, val, thumb, page, range);
					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "Slider") == 0)
				{
					int val = 1, min = 0, max = 10;

					val = obj->GetPropInt("value");
					min = obj->GetPropInt("min");
					max = obj->GetPropInt("max");

					fprintf(fp, "\"\"  control = [%d, wx%s, '', 'wxSL_HORIZONTAL', '%s', %d, %d, %d, %d, %d, %d, %d,\\\n",
							obj->GetId(), kls->name, obj->GetName().c_str(),
							rct.x, rct.y, rct.width, rct.height, val, min, max);
					fprintf(fp, WXFONTSPEC);
					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "TextCtrl") == 0)
				{
					
					wxArrayString styles;
					
					wxString value = obj->GetPropString("text");
					if (obj->GetPropBool("editable") == false)
						styles.Add("wxTE_READONLY");
					
					
					if (obj->GetPropBool("multiline"))
						styles.Add("wxTE_MULTILINE");
					else
						styles.Add("wxTE_PROCESS_ENTER");
					
					if (obj->GetPropBool("password"))
						styles.Add("wxTE_PASSWORD");
					
					wxString style = "";
					for (int k=0;k<(int)styles.Count();k++)
					{
						style += styles[k];
						if (k < (int)styles.Count()-1)
							style += " | ";
					}
					
					fprintf(fp, "\"\"  control = [%d, wx%s, '', '%s', '%s', %d, %d, %d, %d, '%s',\\\n",
							obj->GetId(), kls->name, style.c_str(), obj->GetName().c_str(),
							rct.x, rct.y, rct.width, rct.height, value.c_str());
					fprintf(fp, WXFONTSPEC);
					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "RadioButton") == 0)
				{
					wxString label = obj->GetPropString("label");

					int chk = 0;
					if (obj->GetPropBool("state"))
						chk = 1;
							
					// generate the code for the starting radio button
					fprintf(fp, "\"\"  control = [%d, wxRadioButton, '%s', 'wxRB_GROUP', '%s', %d, %d, %d, %d, %d,\\\n",
							obj->GetId(), label.c_str(), obj->GetName().c_str(),
							rct.x, rct.y, rct.width, rct.height, chk);
					fprintf(fp, WXFONTSPEC);
					obj->SetWxrDone(true);
					
					wxString curgroup = obj->GetPropString("group");

					// generate the code for all the radiobuttons in the same group
					for (int k=0;k<radiobuttons.count();k++)
					{
						Object *radio = radiobuttons[k];

						Property *pg = radio->FindProp("group");
						if (pg && pg->string == curgroup && !radio->IsWxrDone())
						{
							label = radio->GetPropString("label");
							int chk = 0;
							if (radio->GetPropBool("state"))
								chk = 1;
							
							// generate the code for the starting radio button
							rct = radio->GetGeom();
							rct.x -= drct.x;
							rct.y -= drct.y;
							fprintf(fp, "\"\"  control = [%d, wxRadioButton, '%s', '0', '%s', %d, %d, %d, %d, %d,\\\n",
									radio->GetId(), label.c_str(), radio->GetName().c_str(),
									rct.x, rct.y, rct.width, rct.height, chk);
							fprintf(fp, WXFONTSPEC);
							radio->SetWxrDone(true);
						}
						
					}
					
				}
			}
			
		}
		
		fprintf(fp, ").\";\n");
		fclose(fp);
	}
	
	return true;
}
