#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <wx/wx.h>
#include <wx/scrolbar.h>
#include <wx/print.h>
#include <wx/printdlg.h>
#include <wx/accel.h>
#include <wx/image.h>
#include <wx/fs_zip.h>
#include <wx/html/htmlwin.h>
#include <wx/config.h>

#include "array.h"
#include "writecode.h"

/*

static void codegen_dialog(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_button(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_checkbox(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_choice(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_staticbox(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_listbox(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_statictext(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_radiobutton(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_scrollbar(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_slider(Object *inst, ObjClass *klass, FILE *fp);
static void codegen_textctrl(Object *inst, ObjClass *klass, FILE *fp);

*/


		
static void rs_start_object(FILE *fp, Object *obj, const wxString &style)
{
	wxRect rct = obj->GetGeom();
	ControlInfo *inf = obj->GetControlInfo();

	if (obj->GetDialog())
	{
		wxRect drct = obj->GetDialog()->GetGeom();
		rct.x -= drct.x;
		rct.y -= drct.y;
	}
	else
	{
		rct.x = -1;
		rct.y = -1;
	}

	fprintf(fp,"\"[%s %d '%s' %d %d %d %d '%s' ",
		inf->name, obj->GetId(), obj->GetName().c_str(),
		rct.x, rct.y, rct.width, rct.height, style.c_str());
}

static void rs_end_object(FILE *fp, Object *obj)
{
	fprintf(fp, " ]\"\n");
}

bool write_rs(const wxString &dirname, const Array<Dialog*> &list)
{
	int id = 100;
	int i;
	
    wxDateTime now = wxDateTime::Now();

	// assign ids to the widgets	
	for (i=0;i<list.count();i++)
	{
		Dialog *dlg = list[i];
		dlg->SetId(id++);
		wxString fn = dirname + "/RS_" + dlg->GetName() + ".h";
		
		FILE *fp = fopen(fn.c_str(), "w");
		if (!fp)
			return false;

		fprintf(fp, "/* Generated by XCS:write_rs %s */\n\n", now.Format("%a %d %b %Y  %H:%M:%S").c_str());
		fprintf(fp, "#define ID_%s %d\n", dlg->GetName().c_str(), dlg->GetId());

			
		int count;
		Object **children = dlg->GetChildren(count);
		for (int i=0;i<count;i++)
		{
			Object *obj = children[i];
			obj->SetId(id++);
			fprintf(fp, "#define ID_%s %d\n", obj->GetName().c_str(), obj->GetId());
		}
		
		fclose(fp);
	}
	
	// generate the resource files
	for (i=0;i<list.count();i++)
	{
		Dialog *dlg = list[i];
		wxRect drct = dlg->GetGeom();
		wxString fn = dirname + "/RS_" + dlg->GetName() + ".r";
	
		//printf("generating wxr file '%s'\n", fn.cStr());
		
		FILE *fp = fopen(fn.c_str(), "w");
		if (!fp)
			return false;


		fprintf(fp, "/* Generated by xcs:write_rs %s */\n\n", now.Format("%a %d %b %Y  %H:%M:%S").c_str());

//EXAMPLE:"[Dialog 100 'NewDialog' -1 -1 400 300 'wxRAISED_BORDER|wxCAPTION' 'Create New Thing Diagram' ]"
//EXAMPLE:"[StaticBox 102 'StaticBox1' 10 5 255 280 'Options Selections']"

		// write the dialog properties	
		fprintf(fp, "static char *RS_%s = \n",  dlg->GetName().c_str());

		
		rs_start_object(fp, dlg, 
			wxString::Format("wxRAISED_BORDER|wxCAPTION%s",
					dlg->IsModal() ? "|wxDIALOG_MODAL" : "") );

		fprintf(fp, "'%s'", dlg->GetTitle().c_str());
		rs_end_object(fp, dlg);

	
		// generate the code for widgets that are lowest on the 
		// stacking order, since the need to be added to the dialog first.
		// currently the only widget generated is a 'StaticBox'
		int count;
								
		Array<Object*> tabchildren; // to hold widgets with tab information
		Array<Object*> nontabchildren; // for all the other widgets
		Array<Object*> radiobuttons; // special list for radiobuttons since order matters for them
				
		int j;
		Object **children = dlg->GetChildren(count);
		for (j=0;j<count;j++)
		{
			children[j]->SetWxrDone(false);
				
			int curorder = -1;
			if ( (curorder = children[j]->GetTabOrder()) >= 0 )
			{
				/* insert the current tab child in sorted order into the tabchildren array */
				int index = 0;
				int k;
				for (k=0;k<tabchildren.count();k++)
				{
					if (tabchildren[k]->GetTabOrder() >= curorder)
						break;

					index++;
				}				
				tabchildren.insert(children[j], index);
			}
			else
			{
				/* this widget does not support tabordering */
				nontabchildren.append(children[j]);
			}
		}
		
		/* now append all the non tab children to the end of the tabchildren 
		to get one correct list of widgets to output the code for */
		
		for (j=0;j<nontabchildren.count();j++)
			tabchildren.append( nontabchildren[j] );

		
		/* now put all the radiobuttons into the list with the correct taborder */

		for (j=0;j<tabchildren.count();j++)
		{
			if (strcmp(tabchildren[j]->GetControlInfo()->name, "RadioButton") == 0)
				radiobuttons.append( tabchildren[j] );
		}
		
		/* now cycle through all the widgets in
		the correctly tab-order sorted list of widgets
		and generate the appropriate code. */
		
		/* write out all the lowered widgets first
		to make sure the they're the lowest on the 
		stacking order in the final dialog (only wxStaticBox here) */
		

		for (j=0;j<tabchildren.count();j++)
		{
			Object *obj = tabchildren[j];
			ControlInfo *kls = obj->GetControlInfo();
			
			// it's a lowered widget and it hasn't been written yet
			if (!obj->IsWxrDone())
			{
				if ( strcmp(kls->name, "StaticBox") == 0)
				{		
					rs_start_object(fp, obj, "");			
					fprintf(fp, "'%s'", obj->GetPropString("label").c_str());
					rs_end_object(fp, obj);
					
					obj->SetWxrDone(true);
				}
			}
		}
		
		// generate code for all the other widgets,
		// but not the radio buttons, since
		// we need to generate those separately to get
		// the groups right
		


		for (j=0;j<tabchildren.count();j++)
		{
			Object *obj = tabchildren[j];
			ControlInfo *kls = obj->GetControlInfo();
			wxRect rct = obj->GetGeom();
			
			rct.x -= drct.x;
			rct.y -= drct.y;

			// make sure it's raised widget that hasn't been written yet
			if (!obj->IsWxrDone())
			{				
				if ( strcmp(kls->name, "Button") == 0 ||
						strcmp(kls->name, "StaticText") == 0 )
				{
					rs_start_object(fp, obj, "");
					fprintf(fp, "'%s'", obj->GetPropString("label").c_str());
					rs_end_object(fp, obj);

					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "Choice") == 0 ||
						strcmp(kls->name, "ListBox") == 0 )
				{
					Property *p = obj->FindProp("data");
					wxString data;
					data.Printf("{%d,", p->string_array.Count());
					if (p)
					{
						for (int k=0;k<(int)p->string_array.Count();k++)
						{
							data += "'" + p->string_array[k] + "'";
							if (k < (int)p->string_array.Count()-1)
								data += ",";
						}
					}
					data += "}";
					
					wxString style = strcmp(kls->name, "ListBox")==0 ? "wxLB_SINGLE" : "";
					
					rs_start_object(fp, obj, style);
					fprintf(fp, "%s", data.c_str());
					rs_end_object(fp, obj);

					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "CheckBox") == 0)
				{
					wxString chk = "'0'";
				
					if (obj->GetPropBool("state"))
						chk = "'1'";
					
					rs_start_object(fp, obj, "");
					fprintf(fp, "%s", chk.c_str());
					fprintf(fp, " '%s'", obj->GetPropString("label").c_str());
					rs_end_object(fp, obj);

					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "ScrollBar") == 0)
				{
					int val=0, thumb=16, page=50, range=100;
					val = obj->GetPropInt("value");
					thumb = obj->GetPropInt("thumbsize");
					page = obj->GetPropInt("pagesize");
					range = obj->GetPropInt("range");
					
					wxString style = "wxSB_HORIZONTAL";
					if (obj->GetPropBool("vertical"))
						style = "wxSB_VERTICAL";
					
					rs_start_object(fp, obj, style);
					fprintf(fp, "'%d %d %d %d'", val, thumb, page, range);
					rs_end_object(fp, obj);

					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "Slider") == 0)
				{
					int val = 1, min = 0, max = 10;

					val = obj->GetPropInt("value");
					min = obj->GetPropInt("min");
					max = obj->GetPropInt("max");

					rs_start_object(fp, obj, "wxSL_HORIZONTAL");
					fprintf(fp, "'%d %d %d'", val, min, max);
					rs_end_object(fp, obj);

					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "TextCtrl") == 0)
				{
					
					wxArrayString styles;
					
					wxString value = obj->GetPropString("text");
					if (obj->GetPropBool("editable") == false)
						styles.Add("wxTE_READONLY");
					
					
					if (obj->GetPropBool("multiline"))
						styles.Add("wxTE_MULTILINE");
					else
						styles.Add("wxTE_PROCESS_ENTER");
					
					if (obj->GetPropBool("password"))
						styles.Add("wxTE_PASSWORD");
					
					wxString style = "";
					for (int k=0;k<(int)styles.Count();k++)
					{
						style += styles[k];
						if (k < (int)styles.Count()-1)
							style += "|";
					}

					rs_start_object(fp, obj, style);
					fprintf(fp, "'%s'", value.c_str());
					rs_end_object(fp, obj);

					obj->SetWxrDone(true);
				}
				else if (strcmp(kls->name, "RadioButton") == 0)
				{
					wxString label = obj->GetPropString("label");

					int chk = 0;
					if (obj->GetPropBool("state"))
						chk = 1;
							
					rs_start_object(fp, obj, "wxRB_GROUP");
					fprintf(fp, "'%d' '%s'", chk, obj->GetPropString("label").c_str());
					rs_end_object(fp, obj);

					obj->SetWxrDone(true);
					
					wxString curgroup = obj->GetPropString("group");

					// generate the code for all the radiobuttons in the same group
					for (int k=0;k<radiobuttons.count();k++)
					{
						Object *radio = radiobuttons[k];

						Property *pg = radio->FindProp("group");
						if (pg && pg->string == curgroup && !radio->IsWxrDone())
						{
							label = radio->GetPropString("label");
							int chk = 0;
							if (radio->GetPropBool("state"))
								chk = 1;
							
							// generate the code for the starting radio button
							rs_start_object(fp, radio, "");
							fprintf(fp, "'%d' '%s'", chk, radio->GetPropString("label").c_str());
							rs_end_object(fp, radio);

							radio->SetWxrDone(true);
						}
						
					}
					
				}
			}
			
		}
		
		fprintf(fp, ";\n");
		fclose(fp);
	}
	
	return true;
}

