
#ifndef __vector_h
#define __vector_h

#include <assert.h>

template <class type>
class Vector
{
public:
	Vector();
	Vector(int size);
	Vector(int size, const type &fill);
	Vector(const Vector &vec);
	~Vector();

	void clear();
		
	const Vector &operator= (const Vector &vec);
	type &operator[] (int i);
	const type &operator[] (int i) const;
	
	type &at(int i);
	const type &at(int i) const;
	
	bool resize(int new_size, bool copy = true);
	int length() const;
	int size() const;
	
	type *data();
	
private:
	int t_size;
	type *t_array;
};



////////////////////////////////////////////////////////////
// templated implementation

template <class type>
Vector<type>::Vector() 
{
	t_size = 0;
	t_array = NULL;
}

template <class type>
Vector<type>::Vector(int size) 
{
	t_size = size;
	t_array = new type[t_size];
}

template <class type>
Vector<type>::Vector(int size, const type &fill) 
{
	t_size = size;
	t_array = new type[t_size];
	for (int i=0; i < t_size; i++) 
		t_array[i] = fill;
}
	
template <class type>
Vector<type>::Vector(const Vector &vec) 
{ 
	t_size = vec.length();
	t_array = new type[t_size];

	for (int i=0; i < t_size; i++)
		t_array[i] = vec.t_array[i];
}

template <class type>
Vector<type>::~Vector()
{
	delete [] t_array;
}

template <class type>
void Vector<type>::clear()
{
	if (t_array)
		delete [] t_array;
	
	t_array = NULL;
	t_size = 0;
}
	
template <class type>
const Vector<type> &Vector<type>::operator= (const Vector &vec)
{
	if (this != &vec)
	{
		delete [] t_array;
		t_size = vec.length();
		t_array = new type[t_size];

		for (int i=0;i<t_size;i++)
			t_array[i] = vec.t_array[i];
	}
	return *this;
}

template <class type>
type &Vector<type>::operator[] (int i)
{
	assert( i >= 0 && i < t_size);
	return t_array[i];
}
	
template <class type>
const type &Vector<type>::operator[] (int i) const
{
	assert( i >= 0 && i < t_size);
	return t_array[i];
}

template <class type>
type &Vector<type>::at (int i)
{
	assert( i >= 0 && i < t_size);
	return t_array[i];
}
	
template <class type>
const type &Vector<type>::at (int i) const
{
	assert( i >= 0 && i < t_size);
	return t_array[i];
}

template <class type>
bool Vector<type>::resize(int new_size, bool copy)
{
	int num_to_copy = new_size < t_size ? new_size : t_size;
	type *buf = new type[new_size];
	
	if (copy)
		for (int i=0;i<num_to_copy;i++)
			buf[i] = t_array[i];
					
	delete [] t_array;
	t_size = new_size;
	t_array = buf;
	
	return t_array != NULL;
}
		
template <class type>
int Vector<type>::length() const
{
	return t_size;
}

template <class type>
int Vector<type>::size() const
{
	return length();
}

template <class type>
type *Vector<type>::data()
{
	return t_array;
}


#endif
