#include "rsdialog.h"



struct rs_wxstyle
{
	char *s_rs;
	int i_rs;
};

static rs_wxstyle wxstyle_table[] =
{
    /* wxListBox */
    { wxT("wxSINGLE"), wxLB_SINGLE },
    { wxT("wxMULTIPLE"), wxLB_MULTIPLE },
    { wxT("wxEXTENDED"), wxLB_EXTENDED },
    { wxT("wxLB_SINGLE"), wxLB_SINGLE },
    { wxT("wxLB_MULTIPLE"), wxLB_MULTIPLE },
    { wxT("wxLB_EXTENDED"), wxLB_EXTENDED },
    { wxT("wxLB_NEEDED_SB"), wxLB_NEEDED_SB },
    { wxT("wxLB_ALWAYS_SB"), wxLB_ALWAYS_SB },
    { wxT("wxLB_SORT"), wxLB_SORT },
    { wxT("wxLB_OWNERDRAW"), wxLB_OWNERDRAW },
    { wxT("wxLB_HSCROLL"), wxLB_HSCROLL },

    /* wxComboxBox */
    { wxT("wxCB_SIMPLE"), wxCB_SIMPLE },
    { wxT("wxCB_DROPDOWN"), wxCB_DROPDOWN },
    { wxT("wxCB_READONLY"), wxCB_READONLY },
    { wxT("wxCB_SORT"), wxCB_SORT },

    /* wxTextCtrl */
    { wxT("wxPASSWORD"), wxPASSWORD},
    { wxT("wxPROCESS_ENTER"), wxPROCESS_ENTER},
    { wxT("wxTE_PASSWORD"), wxTE_PASSWORD},
    { wxT("wxTE_READONLY"), wxTE_READONLY},
    { wxT("wxTE_PROCESS_ENTER"), wxTE_PROCESS_ENTER},
    { wxT("wxTE_MULTILINE"), wxTE_MULTILINE|wxHSCROLL},
    { wxT("wxTE_NO_VSCROLL"), wxTE_NO_VSCROLL},

    /* wxRadioBox/wxRadioButton */
    { wxT("wxRB_GROUP"), wxRB_GROUP },
    { wxT("wxRA_SPECIFY_COLS"), wxRA_SPECIFY_COLS },
    { wxT("wxRA_SPECIFY_ROWS"), wxRA_SPECIFY_ROWS },
    { wxT("wxRA_HORIZONTAL"), wxRA_HORIZONTAL },
    { wxT("wxRA_VERTICAL"), wxRA_VERTICAL },

    /* wxSlider */
    { wxT("wxSL_HORIZONTAL"), wxSL_HORIZONTAL },
    { wxT("wxSL_VERTICAL"), wxSL_VERTICAL },
    { wxT("wxSL_AUTOTICKS"), wxSL_AUTOTICKS },
    { wxT("wxSL_LABELS"), wxSL_LABELS },
    { wxT("wxSL_LEFT"), wxSL_LEFT },
    { wxT("wxSL_TOP"), wxSL_TOP },
    { wxT("wxSL_RIGHT"), wxSL_RIGHT },
    { wxT("wxSL_BOTTOM"), wxSL_BOTTOM },
    { wxT("wxSL_BOTH"), wxSL_BOTH },
    { wxT("wxSL_SELRANGE"), wxSL_SELRANGE },

    /* wxScrollBar */
    { wxT("wxSB_HORIZONTAL"), wxSB_HORIZONTAL },
    { wxT("wxSB_VERTICAL"), wxSB_VERTICAL },

    /* wxDialog */
    { wxT("wxDIALOG_MODAL"), wxDIALOG_MODAL },

    /* Generic */
    { wxT("wxVSCROLL"), wxVSCROLL },
    { wxT("wxHSCROLL"), wxHSCROLL },
    { wxT("wxCAPTION"), wxCAPTION },
    { wxT("wxSTAY_ON_TOP"), wxSTAY_ON_TOP},
    { wxT("wxICONIZE"), wxICONIZE},
    { wxT("wxMINIMIZE"), wxICONIZE},
    { wxT("wxMAXIMIZE"), wxMAXIMIZE},
    { wxT("wxSDI"), 0},
    { wxT("wxMDI_PARENT"), 0},
    { wxT("wxMDI_CHILD"), 0},
    { wxT("wxTHICK_FRAME"), wxTHICK_FRAME},
    { wxT("wxRESIZE_BORDER"), wxRESIZE_BORDER},
    { wxT("wxSYSTEM_MENU"), wxSYSTEM_MENU},
    { wxT("wxMINIMIZE_BOX"), wxMINIMIZE_BOX},
    { wxT("wxMAXIMIZE_BOX"), wxMAXIMIZE_BOX},
    { wxT("wxRESIZE_BOX"), wxRESIZE_BOX},
    { wxT("wxDEFAULT_FRAME_STYLE"), wxDEFAULT_FRAME_STYLE},
    { wxT("wxDEFAULT_FRAME"), wxDEFAULT_FRAME_STYLE},
    { wxT("wxDEFAULT_DIALOG_STYLE"), wxDEFAULT_DIALOG_STYLE},
    { wxT("wxBORDER"), wxBORDER},
    { wxT("wxFIXED_LENGTH"), 0},
    { wxT("wxDOUBLE_BORDER"), wxDOUBLE_BORDER},
    { wxT("wxSUNKEN_BORDER"), wxSUNKEN_BORDER},
    { wxT("wxRAISED_BORDER"), wxRAISED_BORDER},
    { wxT("wxSIMPLE_BORDER"), wxSIMPLE_BORDER},
    { wxT("wxSTATIC_BORDER"), wxSTATIC_BORDER},
    { wxT("wxTRANSPARENT_WINDOW"), wxTRANSPARENT_WINDOW},
    { wxT("wxNO_BORDER"), wxNO_BORDER},
    { wxT("wxCLIP_CHILDREN"), wxCLIP_CHILDREN},
    { wxT("wxCLIP_SIBLINGS"), wxCLIP_SIBLINGS},

	/* end of table */
	{ NULL, -1}

};

struct ObjectInfo
{
	wxString type;
	int id;
	wxString name;
	int x, y, width, height;
	int wxstyle;
	wxArrayString listdata;
	wxString strdata;
	bool bvalue;
	int min, max, val, page, range, thumb;
};

/* EXAMPLE
static char *RS_NewDialog = 
"[Dialog 100 'NewDialog' -1 -1 400 300 'wxRAISED_BORDER|wxCAPTION' 'Create New Thing Diagram' ]"
"[StaticBox 108 'StaticBox1' 10 5 255 280 '' 'Preferences' ]"
"[RadioButton 117 'RadioButton4' 270 85 110 25 'wxRB_GROUP' '1' 'RadioButton2:2' ]"
"[RadioButton 116 'RadioButton3' 270 60 110 25 '' '0' 'RadioButton2:1' ]"
"[ListBox 115 'ListBox1' 20 110 110 120 'wxLB_SINGLE' {3,'slist1','slist2','slist3'} ]"
"[CheckBox 114 'CheckBox3' 145 75 110 25 '' '1' 'CheckBox3' ]"
"[RadioButton 113 'RadioButton2' 270 35 110 25 'wxRB_GROUP' '0' 'RadioButton1:2' ]"
"[RadioButton 110 'RadioButton1' 270 10 110 25 '' '1' 'RadioButton1:1' ]"
"[CheckBox 111 'CheckBox2' 20 65 110 25 '' '1' 'CheckBox2' ]"
"[Choice 107 'Choice1' 145 45 100 25 '' {3,'cho1','cho2','cho3'} ]"
"[CheckBox 106 'CheckBox1' 145 15 110 25 '' '0' 'Not important' ]"
"[Button 105 'CmdCancel' 165 250 80 25 '' 'Cancel' ]"
"[Button 104 'CmdOK' 40 250 80 25 '' 'OK' ]"
"[TextCtrl 102 'Editor' 270 125 110 70 'wxTE_READONLY|wxTE_MULTILINE' 'Test text message' ]"
"[TextCtrl 101 'UserPassword' 20 35 100 25 'wxTE_PROCESS_ENTER|wxTE_PASSWORD' 'hello' ]"
"[StaticText 103 'StaticText1' 280 255 110 25 '' 'Test KLA' ]"
"[Slider 109 'Slider1' 285 210 100 25 'wxSL_HORIZONTAL' '10 0 100' ]"
"[ScrollBar 112 'ScrollBar1' 230 115 15 110 'wxSB_VERTICAL' '1 16 50 100' ]"
*/


static void ReadToken(char * &str, char *buf, char delim)
{
/*	while (*str != 0 && *str == delim)
		str++;
*/
	if (*str == delim)
		str++;

	while (*str != 0 && *str != delim)
		*buf++ = *str++;

	*buf = 0;

	while (*str != 0 && *str == delim)
		str++;
}

static void StripFirstLast(char * &ptr)
{
	int len = strlen(ptr);
	*(ptr+len-1) = 0; /* remove the last character */
	ptr++; /* advance the first character */
}

void SkipWhitespace(char *&str)
{
	while (*str != 0 && (*str == ' ' || *str == '\t'))
		str++; 
}

static int GetWxStyle(char *desc)
{
	int style = 0;
	static char stbuf[256];
	
	while(1)
	{
		ReadToken(desc, stbuf, '|');
		if (strcmp(stbuf, "") == 0)
			return style;

		int i=0;
		while (wxstyle_table[i].s_rs != NULL)
		{
			if (strcmp(wxstyle_table[i].s_rs, stbuf)==0)
			{
				style |= wxstyle_table[i].i_rs;
				break;
			}
			i++;
		}
	}

	return style;
}

#define BUFLEN 2048

#define RO_UNKNOWN -2
#define RO_ERROR -1
#define RO_EOS 0
#define RO_OK 1

static int ReadObject(char * &str, ObjectInfo &info)
{
	static char buf[BUFLEN];
	char *bptr;

	if (!str)
		return RO_ERROR;

	if (*str == 0)
		return RO_EOS;

	if (*str != '[')
		return RO_ERROR;

	str++; /* skip the opening '[' */

	/*OBJECT::TYPE*/

	ReadToken(str, buf, ' ');
	info.type = wxString(buf);

//	wxMessageBox(wxString::Format("read type '%s'", buf));

	/*OBJECT::ID*/

	ReadToken(str, buf, ' ');
	info.id = atoi(buf);

//	wxMessageBox(wxString::Format("read id '%d'", info.id));

	/*OBJECT::NAME*/
	ReadToken(str, buf, ' ');
	bptr = buf;
	StripFirstLast(bptr);
	info.name = wxString(bptr);

//	wxMessageBox(wxString::Format("read name '%s'", bptr));

	/*OBJECT::X*/
	ReadToken(str, buf, ' ');
	info.x = atoi(buf);

	/*OBJECT::Y*/
	ReadToken(str, buf, ' ');
	info.y = atoi(buf);
	
	
	/*OBJECT::WIDTH*/
	ReadToken(str, buf, ' ');
	info.width = atoi(buf);
	
	/*OBJECT::HEIGHT*/
	ReadToken(str, buf, ' ');
	info.height = atoi(buf);

	
//	wxMessageBox(wxString::Format("read geom %d %d %d %d", info.x, info.y, info.width, info.height));

	/*OBJECT::STYLE*/
	ReadToken(str, buf, ' ');
	bptr = buf;
	StripFirstLast(bptr);
	info.wxstyle = GetWxStyle( bptr );

//	wxMessageBox(wxString::Format("read/parsed style '%s'->%x", bptr, info.wxstyle));

	/* skip over any whitespace, now we're on the first property, depends on object type */
	SkipWhitespace(str);

	if (info.type == "Dialog" ||
		info.type == "Button" ||
		info.type == "StaticBox" ||
		info.type == "StaticText" ||
		info.type == "TextCtrl")
	{
		ReadToken(str, buf, '\'');
		info.strdata = wxString(buf);

//		wxMessageBox(wxString::Format("read name='%s'", buf));
	}
	else if (info.type == "RadioButton" ||
			info.type == "CheckBox")
	{
		ReadToken(str, buf, '\'');
		info.bvalue = (bool) atoi(buf);

		SkipWhitespace(str);
		ReadToken(str, buf, '\'');
		info.strdata = wxString(buf);
	}
	else if (info.type == "ListBox" ||
			info.type == "Choice")
	{
		int count;
		if (*str != '{')
			wxMessageBox(wxString::Format("did not find '{' instead: '%c'!", *str));

		str++; /* skip the '{' */
		ReadToken(str, buf, ','); /* read the data count */
		count = atoi(buf);
		str++; /* skip the comma (or '}' if there are count=0)*/

		//wxMessageBox(wxString::Format("Count = %d", count));
		for (int i=0;i<count;i++)
		{
			ReadToken(str, buf, '\'');
			info.listdata.Add( wxString(buf) );

			if (*str != ',' && *str != '}')
			wxMessageBox(wxString::Format("did not find ',' or '}' instead: '%c'!", *str));

			str++; /* skip the comma or '}' if its the last one */
		}
	}
	else if (info.type == "ScrollBar")
	{
		static char numstr[128];
		char *num;

		ReadToken(str, buf, '\'');
		strcpy(numstr, buf);
		num = numstr;
		
		/*val, thumb, page, range */
		ReadToken(num, buf, ' ');
		info.val = atoi(buf);
		
		ReadToken(num, buf, ' ');
		info.thumb = atoi(buf);
		
		ReadToken(num, buf, ' ');
		info.page = atoi(buf);

		ReadToken(num, buf, ' ');
		info.range = atoi(buf);

	}
	else if (info.type == "Slider")
	{
		static char numstr[128];
		char *num;

		ReadToken(str, buf, '\'');
		strcpy(numstr, buf);
		num = numstr;
		
		/*val, min, max */
		ReadToken(num, buf, ' ');
		info.val = atoi(buf);
		
		ReadToken(num, buf, ' ');
		info.min = atoi(buf);
		
		ReadToken(num, buf, ' ');
		info.max = atoi(buf);

	}
	else
	{
		return RO_UNKNOWN;
	}


	/* finish off the object */
	while (*str != 0 && (*str == ' ' || *str == ']'))
		str++;


	return RO_OK;
}

BEGIN_EVENT_TABLE(RSDialog, wxDialog)
	EVT_CHAR_HOOK(RSDialog::OnCharHook)
END_EVENT_TABLE()

RSDialog::RSDialog()
	: wxDialog()
{
	bCancelOnEscape = true;
}


void RSDialog::OnCharHook(wxKeyEvent &evt)
{
	if (bCancelOnEscape && evt.GetKeyCode() == WXK_ESCAPE)
		EndModal( RS_CANCEL );
}

void RSDialog::SetCancelOnEscape(bool b)
{
	bCancelOnEscape = b;
}


int RSDialog::RunModal(const char *rs, wxWindow *parent)
{
	int len = strlen(rs);
	char *work = new char[len+1];
	char *workptr = work;
	int result;

	strcpy(workptr, rs);

	do
	{
		ObjectInfo inf;

//		wxMessageBox(workptr);

		result = ReadObject(workptr, inf);
		wxString type = inf.type;


		if (result == RO_OK)
		{
			if (type == "Dialog")
			{
				this->Create(parent, -1, inf.strdata, wxDefaultPosition, wxSize(inf.width, inf.height), 
					inf.wxstyle | wxDIALOG_MODAL, inf.name);
				this->SetClientSize(inf.width, inf.height);
			}
			else if (type == "Button")
			{
				new wxButton(this, inf.id, inf.strdata, wxPoint(inf.x, inf.y), wxSize(inf.width, inf.height),
					inf.wxstyle, wxDefaultValidator, inf.name);
			}
			else if (type == "CheckBox")
			{
				wxCheckBox *chk = new wxCheckBox(this, inf.id, inf.strdata, wxPoint(inf.x, inf.y), wxSize(inf.width, inf.height),
					inf.wxstyle, wxDefaultValidator, inf.name);

				chk->SetValue( inf.bvalue );

			}
			else if (type == "TextCtrl")
			{
				new wxTextCtrl(this, inf.id, inf.strdata, wxPoint(inf.x, inf.y), wxSize(inf.width, inf.height),
					inf.wxstyle, wxDefaultValidator, inf.name);
			}
			else if (type == "RadioButton")
			{
				wxRadioButton *rb = new wxRadioButton(this, inf.id, inf.strdata, wxPoint(inf.x, inf.y), wxSize(inf.width, inf.height),
					inf.wxstyle, wxDefaultValidator, inf.name);

				rb->SetValue( inf.bvalue );
			}
			else if (type == "StaticBox")
			{
				new wxStaticBox(this, inf.id, inf.strdata, wxPoint(inf.x, inf.y), wxSize(inf.width, inf.height),
					inf.wxstyle, inf.name);

			}
			else if (type == "StaticText")
			{
				new wxStaticText(this, inf.id, inf.strdata, wxPoint(inf.x, inf.y), wxSize(inf.width, inf.height),
					inf.wxstyle, inf.name);
			}
			else if (type == "ScrollBar")
			{
				wxScrollBar *sb = new wxScrollBar(this, inf.id, wxPoint(inf.x, inf.y), wxSize(inf.width, inf.height),
					inf.wxstyle, wxDefaultValidator, inf.name);

				sb->SetScrollbar(inf.val, inf.thumb, inf.range, inf.page, false);

			}
			else if (type == "Slider")
			{
				new wxSlider(this, inf.id, inf.val, inf.min, inf.max, wxPoint(inf.x, inf.y), wxSize(inf.width, inf.height),
					inf.wxstyle, wxDefaultValidator, inf.name);

			}
			else if (type == "Choice")
			{
				wxChoice *ch = new wxChoice(this, inf.id, wxPoint(inf.x, inf.y), wxSize(inf.width, inf.height),
					0, NULL, inf.wxstyle, wxDefaultValidator, inf.name);

				int count = inf.listdata.Count();
				for (int i=0;i<count;i++)
					ch->Append(inf.listdata[i]);

				if (count > 0)
					ch->SetSelection(0);
			}
			else if (type == "ListBox")
			{
				wxListBox *ls = new wxListBox(this, inf.id, wxPoint(inf.x, inf.y), wxSize(inf.width, inf.height),
					0, NULL, inf.wxstyle, wxDefaultValidator, inf.name);

				int count = inf.listdata.Count();
				for (int i=0;i<count;i++)
					ls->Append(inf.listdata[i]);

				if (count > 0)
					ls->SetSelection(0);
			}
			else
			{
				wxMessageBox(
					wxString::Format("Error loading RS dialog resource file {'%s'}.", type.c_str()),
					"Error", wxOK|wxICON_ERROR);
				delete [] work;
				return -999;
			}
		}
	}
	while (result == RO_OK);

	delete [] work;

	OnDlgShow(); /* virtual init function */

	return ShowModal();
}

wxTextCtrl*    RSDialog::TXT(int id)
{
	return (wxTextCtrl*) FindWindowById(id, this);
}


wxStaticText*  RSDialog::LBL(int id)
{
	return (wxStaticText*) FindWindowById(id, this);
}

wxCheckBox*    RSDialog::CHK(int id)
{
	return (wxCheckBox*) FindWindowById(id, this);
}

wxButton*      RSDialog::BTN(int id)
{
	return (wxButton*) FindWindowById(id, this);
}

wxListBox*     RSDialog::LB(int id)
{
	return (wxListBox*) FindWindowById(id, this);
}

wxRadioButton* RSDialog::RB(int id)
{
	return (wxRadioButton*) FindWindowById(id, this);
}

wxSlider*      RSDialog::SL(int id)
{
	return (wxSlider*) FindWindowById(id, this);
}

wxScrollBar*   RSDialog::SB(int id)
{
	return (wxScrollBar*) FindWindowById(id, this);
}

wxChoice*      RSDialog::CH(int id)
{
	return (wxChoice*) FindWindowById(id, this);
}


void RSDialog::OnDlgShow()
{
	/* virtual, nothing to do here */
}

// Dir = 0 to dialog, 1 = from dialog
void RSDialog::Exch_Text(int Dir, int ControlID, wxString &Field)
{
	wxTextCtrl *Control = (wxTextCtrl*) FindWindowById(ControlID, this);
	if (Control != NULL) {
		if (Dir == 0) { // to dialog
			Control->SetValue(Field);
		}
		else {
			Field = Control->GetValue();
		}
	}
}

void RSDialog::Exch_TextAsInt(int Dir, int ControlID, int &Value)
{
	wxTextCtrl *Control = (wxTextCtrl*) FindWindowById(ControlID, this);
	if (Control != NULL) {
		if (Dir == 0) { // to dialog
			Control->SetValue(wxString::Format("%d", Value));
		}
		else {
			Value = atoi(Control->GetValue());
		}
	}
}

void RSDialog::Exch_TextAsDouble(int Dir, int ControlID, double &Value, int Precision)
{
	wxTextCtrl *Control = (wxTextCtrl*) FindWindowById(ControlID, this);
	if (Control != NULL) {
		if (Dir == 0) { // to dialog
			wxString fmt;
			if (Precision < 1)
				fmt = "%g";
			else
				fmt.Printf("%%.%df", Precision);

			Control->SetValue(wxString::Format(fmt.c_str(), Value));
		}
		else {
			Value = atof(Control->GetValue());
		}
	}
}

void RSDialog::Exch_Check(int Dir, int ControlID, bool &Value)
{
	wxCheckBox *Control = (wxCheckBox*) FindWindowById(ControlID, this);
	if (Control != NULL) {
		if (Dir == 0) { // to dialog
			Control->SetValue(Value);
		}
		else {
			Value = Control->GetValue();
		}
	}
}

void RSDialog::Exch_Radio(int Dir, int ControlID, int &Result)
{
	// Find the window of the specified "pilot" (first radio button in group)
	wxRadioButton *Pilot = (wxRadioButton*) FindWindowById(ControlID, this);
	if (Pilot == NULL) return;

	//if (Dir != 0) Result = -1; // in case buttons not found, or none is on

	int nControl = 0;
	// Get child windows of dialog
	wxWindowList &WList = this->GetChildren();

	// Iterate over the children, looking for pilot Radio button
	wxWindowListNode *node = WList.GetFirst();
	while (node) {
	    wxWindow *win = node->GetData();
		if (win->IsKindOf(CLASSINFO(wxRadioButton))) 
			if (Pilot == (wxRadioButton*) win) break;
		node = node->GetNext();
	}
	
	// iterate over the buttons from the pilot, looking for the 'on' button,
	// or setting the appropriate button 'on" depending upon direction
	while (node != NULL) {
	    wxWindow *win = node->GetData();
		if (win->IsKindOf(CLASSINFO(wxRadioButton))) {
			// if this radio button has group set and it's not the pilot, we're done
			if (((win->GetWindowStyle() & wxRB_GROUP) != 0) && (Pilot != (wxRadioButton*) win)) break;
			
			if (Dir == 0) { // to dialog
				((wxRadioButton*)win)->SetValue(nControl == Result);
			}
			else { // from dialog
				if (((wxRadioButton*)win)->GetValue()) {
					// found the button that's on, no need to iterate further
					Result = nControl;
					break;
				}
			}
			nControl++;
		}
		node = node->GetNext();
	}
}

void RSDialog::Exch_Slider(int Dir, int ControlID, int &Value)
{
	wxSlider *Control = (wxSlider*) FindWindowById(ControlID, this);
	if (Control != NULL) {
		if (Dir == 0) { // to dialog
			Control->SetValue(Value);
		}
		else {
			Value = Control->GetValue();
		}
	}
}

void RSDialog::Exch_ScrollBar(int Dir, int ControlID, int &Value)
{
	wxScrollBar *Control = (wxScrollBar*) FindWindowById(ControlID, this);
	if (Control != NULL) {
		if (Dir == 0) { // to dialog
			Control->SetThumbPosition(Value);
		}
		else {
			Value = Control->GetThumbPosition();
		}
	}
}


void RSDialog::Exch_Choice(int Dir, int ControlID, int &Value)
{
	wxChoice *Control = (wxChoice*) FindWindowById(ControlID, this);
	if (Control != NULL) {
		if (Dir == 0) { // to dialog
			Control->SetSelection(Value);
		}
		else {
			Value = Control->GetSelection();
		}
	}
}

void RSDialog::Exch_ChoiceAsText(int Dir, int ControlID, wxString &Value)
{
	wxChoice *Control = (wxChoice*) FindWindowById(ControlID, this);
	if (Control != NULL) {
		if (Dir == 0) { // to dialog
			Control->SetStringSelection(Value);
		}
		else {
			Value = Control->GetStringSelection();
		}
	}
}
