#ifndef __PAINTER_H
#define __PAINTER_H

#include <wx/dc.h>
#include <wx/image.h>

class Painter
{
public:

	enum DrawMode { PIXEL_COPY, PIXEL_INVERT, PIXEL_XOR };
	enum PainterStyle { LINE_SOLID, LINE_ON_OFF_DASH, LINE_DOUBLE_DASH,
								CAP_BUTT, CAP_ROUND, CAP_PROJECTING,
								JOIN_MITER, JOIN_ROUND, JOIN_BEVEL};
	enum ArrowType { UP, DOWN, LEFT, RIGHT };

	Painter(wxDC *dc);
	virtual ~Painter();
	

	wxDC *GetDC();
	void SetDC(wxDC *dc);
	void SetDefaults();
	void SetColour(const wxColour &colour);
	void SetSysWindowColour();
	void SetSysControlColour();
	void SetSysHighlightColour();
	void SetSysTextColour();
	wxColour GetColour();
	void SetBackgroundColour(const wxColour &colour);
	wxColour GetBackgroundColour();
	void SetFont(const wxFont &fnt);
	wxFont &GetFont();
	void SetHelveticaTinyBold();
	void SetHelveticaSmall();
	void SetHelveticaSmallBold();
	void SetHelveticaMedium();
	void SetCourierSmall();
	void SetCourierMedium();
	void SetDrawMode(DrawMode mode);
	void SetLineWidth(unsigned int width);
	void SetLineAttributes(unsigned int width, PainterStyle linestyle, 
		PainterStyle capstyle, PainterStyle joinstyle);
	
	int GetTextWidth(const wxString &text, int length = -1);
	int GetTextHeight(const wxString &text, int length = -1);
	void GetTextExtent(const wxString &text, int &w, int &h, int length = -1);
	int GetCharHeight();

	void DrawPoint(int x, int y);
	void DrawLine(int x1, int y1, int x2, int y2);
	void DrawLines(wxPoint *points, int npoints);
	void DrawPolygon(wxPoint *points, int npoints, bool fill = true);
	void DrawRectangle(int x, int y, int width, int height, bool fill = true);
	void DrawCheckMark(int x, int y, int width, int height, int thick=2);
	void DrawRoundedRect(int x, int y, int width, int height, bool fill, float curvature);
	void DrawEllipse(int x, int y, int width, int height, float start, float end, bool fill);
	void DrawCircle(int x, int y, int radius, bool fill);
	void DrawImageString(int x, int y, const wxString &string);
	void DrawImageText(int x, int y, const char *text, int text_length);
	void DrawString(int x, int y, const wxString &string);
	void DrawText(int x, int y, const char *text, int text_length);
	wxImage *Scale(wxImage *img, int new_width, int new_height);

	
	void DrawXButton(int x, int y, int width, int height);
	void DrawRaisedPanel(int x, int y, int width, int height);
	void DrawSunkenPanel(int x, int y, int width, int height);
	void DrawEngravedPanel(int x, int y, int width, int height, bool fill = true);
	void DrawScrollBar(bool vertical, int x, int y, int width, int height);
	void DrawArrowButton(ArrowType type, int x, int y, int width, int height);
	void DrawArrow(ArrowType type, int x, int y, int width, int height);
	void DrawOutline(int x, int y, int width, int height, bool rev);

private:
	wxPen mPen;
	wxBrush mBrush;

	wxColour mForeground;
	wxColour mBackground;
	wxFont mFont;
	DrawMode mDrawMode;
	int mLineWidth;
	PainterStyle mLineStyle, mCapStyle, mJoinStyle;

	wxDC *mDC;
};


#endif
