
#include "pixmaps/controls/dialog.xpm"
#include "pixmaps/controls/button.xpm"
#include "pixmaps/controls/checkbox.xpm"
#include "pixmaps/controls/choice.xpm"
#include "pixmaps/controls/staticbox.xpm"
#include "pixmaps/controls/listbox.xpm"
#include "pixmaps/controls/statictext.xpm"
#include "pixmaps/controls/radiobutton.xpm"
#include "pixmaps/controls/scrollbar.xpm"
#include "pixmaps/controls/slider.xpm"
#include "pixmaps/controls/textctrl.xpm"

/*
#include "pixmaps/controls/checkbox.xpm"
#include "pixmaps/controls/entry.xpm"
#include "pixmaps/controls/text.xpm"
#include "pixmaps/controls/choice.xpm"
#include "pixmaps/controls/menubar.xpm"
#include "pixmaps/controls/list.xpm"
*/

#include "guibuiltin.h"
#include "xcsguiview.h"
#include "dlgselect.h"
#include "xcswx.h"

const int app_snap_spacing = 5;

void XcsSnapPoint(int *x, int *y)
{
	int xc = *x;
	int yc = *y;

	int box_x, box_x_f, box_x_b, box_y, box_y_f, box_y_b;
	int dist_forward, dist_backward;
	
	box_x_f = box_x_b = xc;
	box_y_f = box_y_b = yc;
		
	dist_forward = 0;
	for (; box_x_f % app_snap_spacing != 0; box_x_f++)
	{
		dist_forward++;
	}
	dist_backward = 0;
	for (; box_x_b % app_snap_spacing != 0; box_x_b--)
	{
		dist_backward++;
	}
	
	if (dist_backward < dist_forward)
		box_x = box_x_b;
	else
		box_x = box_x_f;
		
	
	dist_forward = 0;	
	for (; box_y_f % app_snap_spacing != 0; box_y_f++)
	{
		dist_forward++;
	}
	dist_backward = 0;
	for (; box_y_b % app_snap_spacing != 0; box_y_b--)
	{
		dist_backward++;
	}
	
	if (dist_backward < dist_forward)
		box_y = box_y_b;
	else
		box_y = box_y_f;
	
	*x = box_x;
	*y = box_y;
	
}

//////////////////////////////////////////////////////////////////////
///   Property Sync Callbacks
//////////////////////////////////////////////////////////////////////

static void prop_sync_do_redraw(Property *prop)
{
	if ( prop && prop->object )
	{
		prop->object->Redraw();
	}
}

static void prop_sync_do_dialog_title(Property *prop)
{
	if ( prop && prop->object )
	{
		prop->object->Redraw();
		((Dialog*)prop->object)->GetGUIView()->GetXcsFrame()->GetDlgSelector()->RedrawAll();
	}
}

static void prop_sync_do_radiobutton(Property *prop)
{
	if (prop == NULL || prop->object == NULL)
		return;

	Object *obj = prop->object;
	Dialog *parent;
	Property *grpname, *p;
		
	obj->Redraw();
	
	parent = obj->GetDialog();
	
	p = obj->FindProp("state");
	if (parent && p && p->bvalue == true) // if this radiobutton is active
	{
		grpname = obj->FindProp("group");
		
		if (grpname) // find the group name of this radiobutton
		{
			int count = 0;
			Object **children = parent->GetChildren(count);
			for (int i=0;i<count;i++) // search all the children of the parent
			{
				Object *child = (Object*) children[i];
				if (child != obj  // if not the same object
						&& strcmp(child->GetControlInfo()->name, "RadioButton") == 0) // and the child is a radiobutton
				{
					Property *childprop = child->FindProp("state"); // find that child's state
					Property *childgrp = child->FindProp("group"); // find that child's group
					
					if (childprop && childgrp && childgrp->string == grpname->string)
					{
						childprop->bvalue = false;
						child->Redraw();
					}
				}
			}
		}
	}
	

}

//////////////////////////////////////////////////////////////////////
///   Property and Event Tables
//////////////////////////////////////////////////////////////////////

static PropDef props_dialog[] = {
	{"title", PROP_STRING, prop_sync_do_dialog_title },
	{"modal", PROP_BOOLEAN, NULL},
	{NULL, 0, NULL} };

static PropDef props_button[] = {
	{"label", PROP_STRING, prop_sync_do_redraw },
	{"taborder", PROP_INTEGER, NULL },
	{NULL, 0, NULL} };

static PropDef props_checkbox[] = {
	{"label", PROP_STRING, prop_sync_do_redraw },
	{"state", PROP_BOOLEAN, prop_sync_do_redraw },
	{"taborder", PROP_INTEGER, NULL },
	{NULL, 0, NULL } };
	
static PropDef props_choice[] = {
	{"data", PROP_STRING_ARRAY, prop_sync_do_redraw },
	{"taborder", PROP_INTEGER, NULL },
	{NULL, 0, NULL} };

static PropDef props_staticbox[] = {
	{"label", PROP_STRING, prop_sync_do_redraw },
	{NULL, 0, NULL} };

static PropDef props_listbox[] = {
	{"data", PROP_STRING_ARRAY, prop_sync_do_redraw },
	{"taborder", PROP_INTEGER, NULL },
	{NULL, 0, NULL} };

static PropDef props_statictext[] = {
	{"label", PROP_STRING, prop_sync_do_redraw },
	{NULL, 0, NULL} };

static PropDef props_radiobutton[] = {
	{"label", PROP_STRING, prop_sync_do_redraw },
	{"state", PROP_BOOLEAN, prop_sync_do_radiobutton },
	{"group", PROP_STRING, prop_sync_do_radiobutton },
	{"taborder", PROP_INTEGER, NULL },
	{NULL, 0, NULL} };

static PropDef props_scrollbar[] = {
	{"value", PROP_INTEGER, NULL },
	{"thumbsize", PROP_INTEGER, NULL},
	{"pagesize", PROP_INTEGER, NULL},
	{"range", PROP_INTEGER, NULL},
	{"vertical", PROP_BOOLEAN, prop_sync_do_redraw },
	{NULL, 0, NULL} };

static PropDef props_slider[] = {
	{"value", PROP_INTEGER, prop_sync_do_redraw},
	{"max", PROP_INTEGER, prop_sync_do_redraw},
	{"min", PROP_INTEGER, prop_sync_do_redraw},
	{NULL, 0, NULL} };

static PropDef props_textctrl[] = {
	{"text", PROP_STRING, prop_sync_do_redraw },
	{"editable", PROP_BOOLEAN, NULL},
	{"multiline", PROP_BOOLEAN, prop_sync_do_redraw },
	{"password", PROP_BOOLEAN, prop_sync_do_redraw },
	{"taborder", PROP_INTEGER, NULL },
	{NULL, 0, NULL} };


//////////////////////////////////////////////////////////////////////
///   Object Class Init Callbacks
//////////////////////////////////////////////////////////////////////

static void objinit_dialog(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("title", obj->GetName());
	obj->SetProp("modal", false);
}

static void objinit_button(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("label", obj->GetName());
	obj->SetProp("taborder", 0);
}

static void objinit_checkbox(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("label", obj->GetName());
	obj->SetProp("state", true);
	obj->SetProp("taborder", 0);
}

static void objinit_choice(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("taborder", 0);
}

static void objinit_staticbox(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("label", obj->GetName() + " Group");
}

static void objinit_listbox(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("taborder", 0);
}

static void objinit_statictext(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("label", obj->GetName());
}

static void objinit_radiobutton(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("label", obj->GetName());
	obj->SetProp("state", false);
	obj->SetProp("group", wxString("RadioGroup1"));
	obj->SetProp("taborder", 0); 
}

static void objinit_scrollbar(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("value", 1);
	obj->SetProp("thumbsize", 16);
	obj->SetProp("pagesize", 50);
	obj->SetProp("range", 100);
	obj->SetProp("vertical", true);
}

static void objinit_slider(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("value", 10);
	obj->SetProp("max", 100);
	obj->SetProp("min", 0);
}

static void objinit_textctrl(Object *obj, ControlInfo *ctrlinfo)
{
	obj->SetProp("text", obj->GetName());
	obj->SetProp("editable", true);
	obj->SetProp("multiline", false);
	obj->SetProp("password", false);
	obj->SetProp("taborder", 0);	
}

//////////////////////////////////////////////////////////////////////
///   Object Paint Callbacks
//////////////////////////////////////////////////////////////////////

static void paint_dialog(Painter &gfx, const wxRect &geom, Object *inst)
{
	gfx.SetSysControlColour();
	gfx.DrawRectangle(geom.x, geom.y, geom.width, geom.height, true);

	int spacing = app_snap_spacing * 2;

	gfx.SetColour( *wxWHITE );
	for (int i=spacing;i<geom.width;i+=spacing)
		for(int j=spacing;j<geom.height;j+=spacing)
			gfx.DrawPoint(geom.x+i ,geom.y+j);
}

static void paint_button(Painter &gfx, const wxRect &geom, Object *inst)
{
	gfx.SetHelveticaSmall();
	gfx.SetSysControlColour();
	gfx.DrawRaisedPanel(geom.x, geom.y, geom.width, geom.height);

	gfx.SetSysTextColour();

	wxString label = inst->GetPropString("label");	
	int sz_width, sz_height;
	gfx.GetTextExtent( label, sz_width, sz_height );

	gfx.DrawString( geom.x+geom.width/2-sz_width/2, 
		geom.y+(geom.height - gfx.GetCharHeight())/2,
		label);
}


static void paint_checkbox(Painter &gfx, const wxRect &geom, Object *inst)
{		
	wxString label = inst->GetPropString("label");
	if (inst->GetData() > 0)
	{
		gfx.SetSysControlColour();
		gfx.DrawRectangle( geom.x+18, geom.y+geom.height/2-gfx.GetCharHeight()/2-1, 
				inst->GetData(), gfx.GetCharHeight()+3, true);
	}
	
	gfx.SetHelveticaSmall();
	gfx.SetSysTextColour();
	inst->SetData( gfx.GetTextWidth( label ) );

	gfx.DrawString(geom.x+18, geom.y+ (geom.height - gfx.GetCharHeight())/2, label );
	
	gfx.SetColour("white");
	gfx.DrawSunkenPanel(geom.x+3, geom.y+geom.height/2-6, 12, 12);
	
	if (inst->GetPropBool("state"))
	{
		gfx.SetColour("black");
		gfx.DrawCheckMark(geom.x+3, geom.y+geom.height/2-6, 12, 12);
	}
}

static void paint_choice(Painter &gfx, const wxRect &geom, Object *inst)
{
	Property *prop;
			
	gfx.SetSysControlColour();
	gfx.DrawRaisedPanel(geom.x, geom.y, geom.width, geom.height);
	gfx.SetColour("white");
	gfx.DrawSunkenPanel(geom.x+2, geom.y+2, geom.width-25, geom.height-4);

	gfx.SetHelveticaSmall();
	gfx.SetSysTextColour();

	prop = inst->FindProp("data");
	if (prop && prop->string_array.Count() > 0)
		gfx.DrawString(geom.x+8, geom.y + (geom.height-gfx.GetCharHeight())/2, prop->string_array[0]);
	else
		gfx.DrawString(geom.x+8, geom.y + (geom.height-gfx.GetCharHeight())/2, "<None>");
	
	gfx.DrawArrow(Painter::DOWN, geom.x+geom.width-18, geom.y+geom.height/2-5, 10, 10);
}

static void paint_staticbox(Painter &gfx, const wxRect &geom, Object *inst)
{
	gfx.SetSysControlColour();
	gfx.DrawRectangle(geom.x, geom.y, geom.width, 14, true );
	gfx.DrawEngravedPanel(geom.x, geom.y+6, geom.width, geom.height-7, false);

	gfx.SetHelveticaSmall();
	wxString label = inst->GetPropString("label");
	
	int w = gfx.GetTextWidth( label );
	gfx.DrawRectangle(geom.x+5, geom.y, w+2, 14, true);
		
	gfx.SetSysTextColour();
	gfx.DrawString(geom.x+6, geom.y, label);
}

static void paint_listbox(Painter &gfx, const wxRect &geom, Object *inst)
{
	Property *prop;
	
	gfx.SetColour("white");
	gfx.DrawSunkenPanel(geom.x, geom.y, geom.width, geom.height);
	
	prop = inst->FindProp("data");
	if (prop)
	{
		int i;
		
		gfx.SetHelveticaSmall();
		gfx.SetColour( *wxBLACK );
		int ct = prop->string_array.Count();
		if (ct > 0)
		{
			for (i=0;i<ct;i++)
				gfx.DrawString (geom.x+5, 3 + geom.y + (1+gfx.GetCharHeight())*i, prop->string_array[i]);
		}
		else
			gfx.DrawString(geom.x+5, geom.y+4, "(Empty ListBox)");
	}
	
	gfx.SetSysControlColour();
	gfx.DrawScrollBar(true, geom.x+geom.width-15, geom.y, 15, geom.height);
}

static void paint_statictext(Painter &gfx, const wxRect &geom, Object *inst)
{
	gfx.SetHelveticaSmall();
	wxString label = inst->GetPropString("label");
	if (inst->GetData() > 0)
	{
		gfx.SetSysControlColour();
		gfx.DrawRectangle( geom.x+2, geom.y+geom.height/2-gfx.GetCharHeight()/2-1, 
				inst->GetData()+2, gfx.GetCharHeight()+3, true);
	}
	
	gfx.SetSysTextColour();
	inst->SetData( gfx.GetTextWidth( label ) );
	gfx.DrawString( geom.x+3, geom.y+ (geom.height - gfx.GetCharHeight())/2, label);	
}

static void paint_radiobutton(Painter &gfx, const wxRect &geom, Object *inst)
{
	wxString label = inst->GetPropString("label");

	gfx.SetHelveticaSmall();
	if (inst->GetData() > 0)
	{
		gfx.SetSysControlColour();
		gfx.DrawRectangle( geom.x+18, geom.y+geom.height/2-gfx.GetCharHeight()/2-1, 
			inst->GetData(), gfx.GetCharHeight()+3, true);
	}
	
	gfx.SetSysTextColour();
	inst->SetData( gfx.GetTextWidth( label ) );
	gfx.DrawString( geom.x+18, geom.y+ (geom.height - gfx.GetCharHeight())/2, label);

	gfx.SetColour("white");
	
	gfx.DrawEllipse(geom.x+3, geom.y+geom.height/2-6, 12, 12, 0, 360, true);
	gfx.SetColour("black");
	gfx.DrawEllipse(geom.x+3, geom.y+geom.height/2-6, 12, 12, 0, 360, false);
	
	if (inst->GetPropBool("state"))
		gfx.DrawEllipse(geom.x+5, geom.y+geom.height/2-4, 8, 8, 0, 360, true);
}

static void paint_scrollbar(Painter &gfx, const wxRect &geom, Object *inst)
{
	gfx.SetSysControlColour();
	gfx.DrawScrollBar( inst->GetPropBool("vertical"),
		geom.x, geom.y, geom.width, geom.height);
}

static void paint_slider(Painter &gfx, const wxRect &geom, Object *inst)
{
	gfx.SetSysControlColour();
	gfx.DrawEngravedPanel(geom.x, geom.y+geom.height/2-2, geom.width, 4, true);
	int min = inst->GetPropInt("min");
	int max = inst->GetPropInt("max");
	int val = inst->GetPropInt("value");

	float percent = ((float)val)/( (float)(max-min) );
	int barx = geom.x + geom.width*percent;
	gfx.DrawRaisedPanel(barx-3, geom.y, 6, geom.height);
}

static void paint_textctrl(Painter &gfx, const wxRect &geom, Object *inst)
{
	int i, len;

	gfx.SetColour("white");
	gfx.DrawSunkenPanel(geom.x, geom.y, geom.width, geom.height);
	
	wxString text = inst->GetPropString("text");
	
	if (inst->GetPropBool("password"))
	{
		len = text.Len();
		text = "";
		for (i=0;i<len;i++)
			text += "*";
	}
	
	gfx.SetSysTextColour();
	gfx.DrawString(geom.x+5, geom.y+3, text);
	
	if (inst->GetPropBool("multiline"))
	{

		gfx.SetSysControlColour();
		gfx.DrawScrollBar(true, geom.x + geom.width-15, geom.y, 15, geom.height-15);
		gfx.DrawScrollBar(false, geom.x, geom.y+geom.height-15, geom.width-15, 15);
		
		gfx.DrawRectangle(geom.x+geom.width-15, geom.y+geom.height-15, 15, 15, true);

	}
}

/*

static void paint_menubar(Painter &gfx, const wxRect &geom, Object *inst)
{
	Property *prop;

	gfx.SetColour( inst->GetPropColour("backcolor") );
	gfx.DrawRaisedPanel(geom.x, geom.y, geom.width, geom.height);
	
	gfx.SetColour( *wxBLACK );
	prop = inst->FindProp("menu");
	if (prop)
	{
		int i;
		int curx = geom.x+10;
		int y = geom.y+geom.height/2 - gfx.GetCharHeight()/2;
		
		int nitems = prop->menu.count();

		for(i=0;i<nitems;i++)
		{
			if (prop->menu[i].level == 0)
			{
				if (prop->menu[i].checkable)
				{
					gfx.SetColour( *wxWHITE );
					gfx.DrawSunkenPanel(curx, y-9, 10, 10);
					curx += 12;
				}
				
				if (prop->menu[i].enabled)
					gfx.SetColour(*wxBLACK);
				else
					gfx.SetColour("gray");
									
				gfx.DrawString(curx, y, prop->menu[i].name);
				curx += gfx.GetTextWidth(prop->menu[i].name) + 10;
			}
		}
	}
}

*/

//////////////////////////////////////////////////////////////////////
///   Object Is Point Within Callbacks
//////////////////////////////////////////////////////////////////////

static bool iswithin_default(int x, int y, Object *inst)
{
	wxRect rct = inst->GetGeom();
	return ( x >= rct.x && x < rct.x+rct.width && y >= rct.y && y < rct.y+rct.height );
}


static bool iswithin_staticbox(int x, int y, Object *inst)
{
	wxRect geom = inst->GetGeom();
	if (x >= geom.x+4 && x < geom.x+geom.width-4 &&
			y >= geom.y+14 && y < geom.y+geom.height-4 )
	{
		return false;
	}
	else
	{
		return iswithin_default(x,y,inst);
	}
}

//////////////////////////////////////////////////////////////////////
///   Main Object Table
//////////////////////////////////////////////////////////////////////

ControlInfo xcs_controls[] = {

/*  wx create id,        name,          pixmap,          type,           default size       properties,        events,           objinit          paint function     iswithin            dotted */
{ XCS_ADD_CONTROL_ID,    "Dialog",      dialog_xpm,      CTRL_DIALOG,    0,  0,  420, 300,  props_dialog,      NULL,         objinit_dialog,      paint_dialog,      iswithin_default,   false  },
{ XCS_ADD_CONTROL_ID+1,  "Button",      button_xpm,      CTRL_STANDARD,  10, 15, 80, 25,    props_button,      NULL,         objinit_button,      paint_button,      iswithin_default,   false  },
{ XCS_ADD_CONTROL_ID+2,  "CheckBox",    checkbox_xpm,    CTRL_STANDARD,  10, 15, 110, 25,   props_checkbox,    NULL,         objinit_checkbox,    paint_checkbox,    iswithin_default,   true   },
{ XCS_ADD_CONTROL_ID+3,  "Choice",      choice_xpm,      CTRL_STANDARD,  10, 15, 100, 25,   props_choice,      NULL,         objinit_choice,      paint_choice,      iswithin_default,   false  },
{ XCS_ADD_CONTROL_ID+4,  "StaticBox",   staticbox_xpm,   CTRL_STANDARD,  10, 5, 200, 200,   props_staticbox,   NULL,         objinit_staticbox,   paint_staticbox,   iswithin_staticbox, false  },
{ XCS_ADD_CONTROL_ID+5,  "ListBox",     listbox_xpm,     CTRL_STANDARD,  10, 15, 110, 120,  props_listbox,     NULL,         objinit_listbox,     paint_listbox,     iswithin_default,   false  },
{ XCS_ADD_CONTROL_ID+6,  "StaticText",  statictext_xpm,  CTRL_STANDARD,  10, 15, 110, 25,   props_statictext,  NULL,         objinit_statictext,  paint_statictext,  iswithin_default,   true   },
{ XCS_ADD_CONTROL_ID+7,  "RadioButton", radiobutton_xpm, CTRL_STANDARD,  10, 15, 110, 25,   props_radiobutton, NULL,         objinit_radiobutton, paint_radiobutton, iswithin_default,   true   },
{ XCS_ADD_CONTROL_ID+8,  "ScrollBar",   scrollbar_xpm,   CTRL_STANDARD,  15, 15, 15, 110,   props_scrollbar,   NULL,         objinit_scrollbar,   paint_scrollbar,   iswithin_default,   false  },
{ XCS_ADD_CONTROL_ID+9,  "Slider",      slider_xpm,      CTRL_STANDARD,  15, 15, 100, 15,   props_slider,      NULL,         objinit_slider,      paint_slider,      iswithin_default,   true   },
{ XCS_ADD_CONTROL_ID+10, "TextCtrl",    textctrl_xpm,    CTRL_STANDARD,  15, 15, 100, 25,   props_textctrl,    NULL,         objinit_textctrl,    paint_textctrl,    iswithin_default,   false  }

/*
{ XCS_ADD_CONTROL_ID+2,  "CheckBox",    checkbox_xpm, CTRL_STANDARD,  10, 10, 110, 25,   props_checkbox,    NULL,         objinit_checkbox,    paint_checkbox,    iswithin_default   },
{ XCS_ADD_CONTROL_ID+3,  "Entry",       entry_xpm,    CTRL_STANDARD,  10, 10, 110, 25,   props_entry,       NULL,         objinit_entry,       paint_entry,       iswithin_default   },
{ XCS_ADD_CONTROL_ID+4,  "TextEditor",  text_xpm,     CTRL_STANDARD,  10, 10, 200, 150,  props_texteditor,  NULL,         objinit_texteditor,  paint_texteditor,  iswithin_default   },
{ XCS_ADD_CONTROL_ID+5,  "Choice",      choice_xpm,   CTRL_STANDARD,  10, 10, 110, 25,   props_choice,      NULL,         objinit_choice,      paint_choice,      iswithin_default   },
{ XCS_ADD_CONTROL_ID+6,  "ListBox",     list_xpm,     CTRL_STANDARD,  10, 10, 100, 170,  props_listbox,     NULL,         objinit_listbox,     paint_listbox,     iswithin_default   }
*/
};

#define FORM_CONTROL 0
#define CONTROL_COUNT 11

ControlInfo *XcsGetControls(int &count)
{
	count = CONTROL_COUNT;
	return xcs_controls;
}

ControlInfo *XcsFindControlInfo(int wxid)
{
	for (int i=0;i<CONTROL_COUNT;i++)
	{
		if (xcs_controls[i].wxid == wxid)
			return &xcs_controls[i];
	}

	return NULL;
}

ControlInfo *XcsFindControlInfo(const char *name)
{
	for (int i=0;i<CONTROL_COUNT;i++)
	{
		if (strcmp(xcs_controls[i].name,name)==0)
			return &xcs_controls[i];
	}

	return NULL;
}