#ifndef __editctrls_h
#define __editctrls_h

#include <wx/wx.h>
#include "painter.h"

class StrEditDialog : public wxDialog
{
public:
	StrEditDialog(wxWindow *parent);
	bool RunDialog(wxArrayString &array);

private:
	void OnCommand(wxCommandEvent &evt);
	wxListBox *mListBox;
	wxButton *mAdd, *mInsertBefore, 
		*mInsertAfter, *mRemove, *mClear;

	DECLARE_EVENT_TABLE();
};

class EditorCtrl
{
public:
	EditorCtrl(wxWindow *hwnd);
	virtual ~EditorCtrl();

	virtual void draw(Painter &gfx) = 0;

	virtual void onchar(wxKeyEvent &evt) { }
	virtual void onleftdown(wxMouseEvent &evt) { }
	virtual void onleftup(wxMouseEvent &evt) { }
	virtual void onmousemove(wxMouseEvent &evt) { }
	virtual void ondblclick(wxMouseEvent &evt) { }

	void setfocus(bool focus);
	bool hasfocus();

	void redraw();	
	void setgeom(const wxRect &rct);
	wxRect getgeom();
	int getx();
	int gety();
	int getwidth();
	int getheight();
	wxWindow *gethwnd();

protected:
	bool focus;
	wxRect geom;
	wxWindow *hwnd;
};


class checkedit : public EditorCtrl
{
public:
	checkedit(wxWindow *hwnd);

	void togglecallback( void (*cb)(checkedit *e, void *data), void *data);
	void setvalue(bool b);
	bool getvalue();

	void draw(Painter &gfx);
	void onchar(wxKeyEvent &evt);
	void onleftdown(wxMouseEvent &evt);
	void ondblclick(wxMouseEvent &evt);

private:
	void (*togglecb)(checkedit *e, void *data);
	void *toggle_data;
	bool value;
};

class strlistedit : public EditorCtrl
{
public:
	strlistedit(wxWindow *hwnd);

	void changedcallback( void (*cb)(strlistedit *e, void *data), void *data);
	void setstrings(const wxArrayString &strs);
	wxArrayString getstrings();

	void draw(Painter &gfx);
	void onleftdown(wxMouseEvent &evt);

private:
	void (*changedcb)(strlistedit *e, void *data);
	void *changed_data;
	wxArrayString value;
};


class colouredit : public EditorCtrl
{
public:
	colouredit(wxWindow *hwnd);
	void changedcallback( void (*cb)(colouredit *e, void *data), void *data);
	void setcolour(const wxColour &c);
	wxColour getcolour();

	void draw(Painter &gfx);
	void onleftdown(wxMouseEvent &evt);
private:
	void (*changedcb)(colouredit *e, void *data);
	void *changed_data;
	wxColour value;
};

class entry : public EditorCtrl, public wxTimer
{
public:
	enum { STRING, BOOLEAN, INTEGER, FLOAT };
	
	entry(wxWindow *hwnd);
	virtual ~entry();

	void activatecallback( void (*cb)(entry *e, void *data), void *data);
	void changedcallback( void (*cb)(entry *e, void *data), void *data);

	void setmode(int m);
	int getmode();

	void settext(const char *s);
	const char *gettext(); // do not free the buffer returned!
	void ins(int &start_position, const char *s, int length=-1);
	void del(int start, int length=-1);
	void backspacekey();
	void deletekey();
	void clear();
	int cursorpos();
	void setcursorpos(int c);
	void cursforward(bool mark=false);
	void cursbackward(bool mark=false);
	void home(bool mark=false);
	void end(bool mark=false);
	bool hasselectedtext();
	int selstart();
	int selend();
	int sellength();
	int textlength();
	void selectall();
	void select(int start, int end);
	void deselect();

	void setval(int v);
	void setval(float v, int digits=-1);
	void setval(bool b);
	int getint();
	float getfloat();
	bool getbool();
	void setstep(float val);
	float getstep();
	void setrange(float min, float max);
	void getrange(float &min, float &max);
	int clampval(int v);
	float clampval(float f);
	bool isoutofrange();
	void increment();
	void decrement();
	
	void seteditable(bool b);
	bool iseditable();

	virtual void Notify();

	void draw(Painter &gfx);
	void onchar(wxKeyEvent &evt);
	void onleftdown(wxMouseEvent &evt);
	void onleftup(wxMouseEvent &evt);
	void onmousemove(wxMouseEvent &evt);
	void ondblclick(wxMouseEvent &evt);


private:
	void (*activatecb)(entry *e, void *data);
	void *activate_data;
	void (*changedcb)(entry *e, void *data);
	void *changed_data;

	int mode;
	
	int onspinner(int nx, int ny);
	int eawidth();
	bool charok(char c);
	int xpostocursorpos(char *s, int xpos);
	int showlastpartoffset(char *s, int width);
	int lastcharvisible();
	void growbuffer();
	
	int curtimer;

	int lastndigits;
	int spintimer_id;
	bool spinning;
	bool incrementing;
	int timer_id;
	char *buffer;
	int buffer_size, text_length;
	int cursor_pos;
	int offset;
	int selection_anchor;
	int selection_drag;
	int margin;
	bool drag_scrolling;
	bool mouse_down;
	bool scrolling_left;
		
	int ivalue, ndigits;
	float fvalue, step, minimum, maximum;
	bool editable;
};




#endif
