#ifndef DLGSELECT_H
#define DLGSELECT_H

#include <wx/wx.h>
#include "xcsguiview.h"
#include "xcspropedit.h"
#include "xcshelp.h"
#include "xcswx.h"
#include "controls.h"

class DlgSelector : public wxWindow
{
public:
	DlgSelector(XcsFrame *parent, XcsGUIView *view);
	virtual ~DlgSelector();
	
	void SetDialog(Dialog *dlg);
	void UpdateList();

	void RedrawAll();
private:
	void Draw(wxDC &dc);

	void OnLeftButtonDown(wxMouseEvent &evt);
	void OnLeftButtonUp(wxMouseEvent &evt);
	void OnSize(wxSizeEvent &evt);
	void OnPaint(wxPaintEvent &evt);

	XcsFrame *mFrame;
	XcsGUIView *mGUIView;

	wxBitmap *mBufBitmap;

	Array<Dialog*> mDialogs;
	int mSelection;

DECLARE_EVENT_TABLE();
};


#endif
