#include "dlgselect.h"

BEGIN_EVENT_TABLE( DlgSelector, wxWindow )
	EVT_LEFT_DOWN( DlgSelector::OnLeftButtonDown )
	EVT_LEFT_UP( DlgSelector::OnLeftButtonUp )
	EVT_PAINT( DlgSelector::OnPaint )
	EVT_SIZE( DlgSelector::OnSize )
END_EVENT_TABLE()

#define ITEM_HEIGHT 35

DlgSelector::DlgSelector(XcsFrame *parent, XcsGUIView *view)
	: wxWindow(parent, -1, wxPoint(100,100), wxSize(150, 200), wxWANTS_CHARS)
{
	mFrame = parent;
	mGUIView = view;
	mBufBitmap = new wxBitmap(300, 300);
	mDialogs.clear();
	mSelection = -1;

}

DlgSelector::~DlgSelector()
{
	/* nothing to do */
	delete mBufBitmap;
}

void DlgSelector::SetDialog(Dialog *dlg)
{
	int idx = mDialogs.find(dlg);
	if (idx >= 0)
	{
		mSelection = idx;
		RedrawAll();
	}
}

void DlgSelector::UpdateList()
{
	mDialogs.clear();
	int ct = mGUIView->GetDialogCount();
	for (int i=0;i<ct;i++)
		mDialogs.append(mGUIView->GetDialog(i));
	mSelection = -1;

	RedrawAll();
}


void DlgSelector::RedrawAll()
{
	wxMemoryDC dc;
	dc.SelectObject(*mBufBitmap);
	
	Painter gfx(&dc);
	Draw(dc);

	wxClientDC cdc(this);
	cdc.Blit(0, 0, mBufBitmap->GetWidth(), mBufBitmap->GetHeight(), &dc, 0, 0);

	dc.SelectObject( wxNullBitmap );
}

void DlgSelector::Draw(wxDC &dc)
{
	wxSize sz = GetSize();
	Painter gfx(&dc);
	gfx.SetColour( *wxWHITE );
	gfx.DrawRectangle(0, 0, sz.GetWidth(), sz.GetHeight());

	gfx.SetHelveticaTinyBold();
	for (int i=0;i<mDialogs.count();i++)
	{
		int ypos = i*ITEM_HEIGHT+1;
		if (mSelection == i)
			gfx.SetColour( wxColour(10, 0, 100) );
		else
			gfx.SetSysControlColour();
		gfx.DrawRectangle(2, ypos+2, sz.GetWidth()-4, ITEM_HEIGHT-4, true);

		if (mSelection == i)
			gfx.SetColour( *wxWHITE );
		else
			gfx.SetColour( *wxBLACK );

		gfx.GetDC()->SetClippingRegion(0, ypos, sz.GetWidth()-4, ITEM_HEIGHT);
		gfx.DrawString(8, ypos+ITEM_HEIGHT/2-gfx.GetCharHeight()/2, mGUIView->GetDialog(i)->GetTitle());
		gfx.GetDC()->DestroyClippingRegion();

	//	gfx.SetSysControlColour();
	//	gfx.DrawXButton( sz.GetWidth()-18, ypos+ITEM_HEIGHT/2-6, 12, 12);
	}
}

void DlgSelector::OnLeftButtonDown(wxMouseEvent &evt)
{
	int y = evt.GetY();
	for (int i=0;i<mDialogs.count();i++)
	{
		int ypos = i*ITEM_HEIGHT+1;
		if (y > ypos && y < ypos+ITEM_HEIGHT)
		{
			mGUIView->ClearSelections();
			mGUIView->SetActiveDialog(mDialogs[i]);
			mSelection = i;
			RedrawAll();
		}
	}
}

void DlgSelector::OnLeftButtonUp(wxMouseEvent &evt)
{
}

void DlgSelector::OnSize(wxSizeEvent &evt)
{
	wxSize wsz = evt.GetSize();
	if (mBufBitmap->GetWidth() < wsz.GetWidth() ||
		mBufBitmap->GetHeight() < wsz.GetHeight() )
	{
		delete mBufBitmap;
		mBufBitmap = new wxBitmap(wsz.GetWidth(), wsz.GetHeight());
		RedrawAll();
	}
}

void DlgSelector::OnPaint(wxPaintEvent &evt)
{
	wxPaintDC dc(this);
	PrepareDC(dc);

	dc.BeginDrawing();
	Draw( dc );
	dc.EndDrawing();
}

