#ifndef CONTROLS_H
#define CONTROLS_H

#include <wx/string.h>
#include <wx/dc.h>
#include <wx/gdicmn.h>

#include "painter.h"
#include "array.h"

class XcsGUIView;
class Dialog;
class Object;
class Property;
struct MenuDef;
struct ControlInfo;


#define XCS_ADD_CONTROL_ID 9000

enum ControlType { CTRL_DIALOG, CTRL_STANDARD, CTRL_NONGUI };

struct PropDef
{
	char *name;
	int type;
	void (*sync)(Property *prop);
};

struct ControlInfo
{
	long wxid;
	const char *name;
	char **pixmap21x21;
	ControlType type;
	int x;
	int y;
	int width;
	int height;
	PropDef *properties;
	char **events;
	void (*objinit)(Object *obj, ControlInfo *ctrlinfo);
	void (*paint)(Painter &gfx, const wxRect &geom, Object *inst);
	bool (*iswithin)(int x, int y, Object *inst);
	bool draw_dotted_box;
};

struct MenuDef
{
	int level;
	wxString name;
	bool checkable;
	bool separator;
	bool enabled;
	char accel;
	int mod;
};

#define MENUDEF_MOD_NONE 0
#define MENUDEF_MOD_CTRL 1
#define MENUDEF_MOD_ALT 2
#define MENUDEF_MOD_SHIFT 3

#define PROP_STRING 1
#define PROP_INTEGER 2
#define PROP_STRING_ARRAY 3
#define PROP_FLOAT 4
#define PROP_BOOLEAN 5
#define PROP_COLOUR 6
#define PROP_MENU 7


class Object;

class Property
{
public:
	Property();
	Property(const wxString &name, int type = PROP_INTEGER);
	Property &operator=(const Property &p);

	int type;
	Object *object;
	void (*sync_cb)(Property *prop);

	wxString name;
	int ivalue;
	bool bvalue;
	float fvalue;
	wxString string;
	wxArrayString string_array;
	Array<MenuDef> menu;
	wxColour colour;
	int step, min, max;

	
	void Write(FILE *fp);
	bool Read(FILE *fp);
};

class Object
{
public:
	Object(ControlInfo *info, const wxString &name);
	virtual ~Object();


	ControlInfo *GetControlInfo();
	wxString GetName();
	void SetName(const wxString &name);

	Property *FindProp(const wxString &name);
	Property *FindOrAddProp(const wxString &name);
	void SetProp(const wxString &name, int val);
	void SetProp(const wxString &name, float val);
	void SetProp(const wxString &name, bool val);
	void SetProp(const wxString &name, const wxString &str);
	void SetProp(const wxString &name, const wxArrayString &str);
	void SetProp(const wxString &name, const wxColour &colour);
	void SetProp(const wxString &name, const Array<MenuDef> menu);

	int NumProps();
	Property *GetProp(int i);

	int GetPropInt(const wxString &name);
	float GetPropFloat(const wxString &name);
	bool GetPropBool(const wxString &name);
	wxString GetPropString(const wxString &name);
	wxColour GetPropColour(const wxString &name);

	void SetGeom(const wxRect &rect);
	void SetGeom(int x, int y, int width, int height);
	void SetPos(int x, int y);
	int GetX();
	int GetY();
	wxRect GetGeom();

	Dialog *GetDialog();
	void SetDialog(Dialog *obj);

	void SetData(long d);
	long GetData();

	void SetId(int id);
	int GetId();

	void SetWxrDone(bool b);
	bool IsWxrDone();

	int GetTabOrder();
	
	virtual void Redraw();
	
protected:
	Dialog *mDialog;
	Property *mXProp, *mYProp, *mWidthProp, *mHeightProp;
	Array<Property*> mProps;
private:
	Property *mNameProp;
	wxRect mRect;
	wxString mName;
	ControlInfo *mCtrlInfo;
	long mData;
	int mId;
	bool mWxrDone;
};

class Dialog : public Object
{
public:
	Dialog(XcsGUIView *view, const wxString &name);
	virtual ~Dialog();

	void AddChild(Object *obj);
	void RemoveChild(Object *obj);
	Object *FindChild(const wxString &name);
	Object **GetChildren(int &count);
	void DeleteChildren();
	
	void RaiseChild(Object *child);
	
	wxString GetTitle();
	bool IsModal();

	XcsGUIView *GetGUIView();

	void Redraw();

private:
	Array<Object*> mChildren;
	XcsGUIView *mGUIView;
};


#endif
